// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/snapshot/error.c $
// $Rev: 54732 $
// $Date: 2024-07-01 08:13:38 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
int error_internal_int(int line, const char* file, int i)
{
	const char*	psz;

	for (;;)	// bypass the directory specification
	{
		psz	= strchr((char*) file, '\\');

		if (psz == NULL)
			psz	= strchr((char*) file, '/');

		if (psz)
			file	= psz + 1;
		else
			break;
	}

	printf(" INTERNAL ERROR: %d, %s: %d\n", line, file, i);
	return(1);
}



//*****************************************************************************
int error_internal_rx_int(rx_data_t* rx, int line, const char* file, int i)
{
	const char*	psz;

	if (rx->err_buf[0] == 0)
	{
		for (;;)	// bypass the directory specification
		{
			psz	= strchr((char*) file, '\\');

			if (psz == NULL)
				psz	= strchr((char*) file, '/');

			if (psz)
				file	= psz + 1;
			else
				break;
		}

		sprintf(rx->err_buf, " INTERNAL ERROR: %d, %s: %d\n", line, file, i);
	}

	return(1);
}


