// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/signals/perform.c $
// $Rev: 53698 $
// $Date: 2023-09-07 13:53:47 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _aux_signals_out(const args_t* args)
{
	int	errs	= 0;

	gsc_label("Auxiliary Clock I/O"); //=======================================
	printf("\n");
	gsc_label_level_inc();

	errs	+= ai32ssc_aux_noise	(args->fd, -1, 1, AI32SSC_AUX_NOISE_HIGH,		NULL);
	errs	+= ai32ssc_aux_out_pol	(args->fd, -1, 1, AI32SSC_AUX_OUT_POL_HI_PULSE,	NULL);
	errs	+= ai32ssc_aux_clk_mode	(args->fd, -1, 1, AI32SSC_AUX_CLK_MODE_OUTPUT,	NULL);

	gsc_label_level_dec();

	gsc_label("Auxiliary SYNC I/O"); //========================================
	printf("\n");
	gsc_label_level_inc();

	errs	+= ai32ssc_aux_sync_mode(args->fd, -1,1,  AI32SSC_AUX_SYNC_MODE_OUTPUT,	NULL);

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static int _cable_clock_io_out(const args_t* args, int tt)
{
	int	errs	= 0;

	gsc_label("Cable Clock I/O");
	printf("\n");

	gsc_label_level_inc();

	if (tt)
		errs	+= ai32ssc_tt_enable(args->fd, -1, 1, AI32SSC_TT_ENABLE_NO,		NULL);

	errs	+= ai32ssc_io_inv		(args->fd, -1, 1, AI32SSC_IO_INV_HIGH,		NULL);
	errs	+= ai32ssc_adc_clk_src	(args->fd, -1, 1, AI32SSC_ADC_CLK_SRC_RAG,	NULL);
	errs	+= ai32ssc_rag_nrate	(args->fd, -1, 1, 500,						NULL);
	errs	+= ai32ssc_rag_enable	(args->fd, -1, 1, AI32SSC_GEN_ENABLE_YES,	NULL);
	errs	+= ai32ssc_adc_enable	(args->fd, -1, 1, AI32SSC_ADC_ENABLE_YES,	NULL);

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static int _cable_sync_io_out_burst(const args_t* args)
{
	int	errs	= 0;

	gsc_label("Cable SYNC I/O");
	printf("(Bursting)\n");

	gsc_label_level_inc();

	errs	+= ai32ssc_burst_sync	(args->fd, -1, 1, AI32SSC_BURST_SYNC_RBG,		NULL);
	errs	+= ai32ssc_rbg_nrate	(args->fd, -1, 1, 2000,							NULL);
	errs	+= ai32ssc_rbg_clk_src	(args->fd, -1, 1, AI32SSC_RBG_CLK_SRC_MASTER,	NULL);
	errs	+= ai32ssc_rbg_enable	(args->fd, -1, 1, AI32SSC_GEN_ENABLE_YES,		NULL);
	errs	+= ai32ssc_burst_size	(args->fd, -1, 1, 3,							NULL);

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static int _cable_sync_io_out_bso(const args_t* args)
{
	int	errs;
	s32	sync	= 0;

	gsc_label("Cable SYNC I/O");
	errs	= ai32ssc_query(args->fd, -1, 0, AI32SSC_QUERY_RBG_SYNC_OUTPUT, &sync);

	if (errs)
	{
	}
	else if (sync == 0)
	{
		printf("SKIPPED  (Rate-B Generator SYNC Output not supported on this device.)\n");
	}
	else
	{
		printf("(Rate-B Generator SYNC Output)\n");
		gsc_label_level_inc();

		errs	+= ai32ssc_rbg_sync_output	(args->fd, -1, 1, AI32SSC_RBG_SYNC_OUTPUT_ENABLE,	NULL);
		errs	+= ai32ssc_rbg_clk_src		(args->fd, -1, 1, AI32SSC_RBG_CLK_SRC_RAG,			NULL);
		errs	+= ai32ssc_reg_mod			(args->fd, -1, 0, AI32SSC_GSC_RBGR, 3, 0xFFFF);
		errs	+= ai32ssc_rbg_nrate		(args->fd, -1, 1, -1,								NULL);
		errs	+= ai32ssc_rbg_enable		(args->fd, -1, 1, AI32SSC_GEN_ENABLE_YES,			NULL);

		gsc_label_level_dec();
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	char	buf[64];
	int		errs	= 0;
	s32		tt		= 0;

	errs	+= ai32ssc_initialize(args->fd, -1, 1);
	errs	+= ai32ssc_query(args->fd, -1, 0, AI32SSC_QUERY_TIME_TAG, &tt);

	errs	+= _cable_clock_io_out(args, tt);

	if (args->rgb_sync_output)
		errs	+= _cable_sync_io_out_bso(args);
	else
		errs	+= _cable_sync_io_out_burst(args);

	errs	+= _aux_signals_out(args);

	//===============================================================
	sprintf(buf, "Waiting (%ld sec%s)", (long) args->seconds, (args->seconds == 1) ? "" : "s");
	gsc_label(buf);
	os_sleep_ms(args->seconds * 1000);
	printf("Done\n");

	errs	+= ai32ssc_initialize(args->fd, -1, 1);

	return(errs);
}



