// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/tt_thr_xx.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd, int index, const char* name, u32 cmd, u32 reg)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	cmd,
			/* arg		*/	0,
			/* reg		*/	reg,
			/* mask		*/	0xFFFF0000,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;
	int	i;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	for (i = 0; (errs == 0) && (i < 16); i++)
	{
		list[0].arg		= 0xFFFF ^ (0x1 << i);
		list[0].value	= 0xFFFF0000 ^ (0x1 << (i + 16));

		errs	+= service_ioctl_set_reg_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);

		list[0].arg		= 0x1 << i;
		list[0].value	= 0x1 << (i + 16);

		errs	+= service_ioctl_set_reg_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}



/******************************************************************************
*
*	Function:	_tt_thr_xx_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_TT_THR_XX.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*		index	The index of the channel being tested.
*
*		name	The text of the IOCTL service macro.
*
*		cmd		The IOCTL service id for the channel to test.
*
*		reg		The register id corresponding to the channel to test.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

static int _tt_thr_xx_test(int fd, int index, const char* name, u32 cmd, u32 reg)
{
	int	errs	= 0;
	s32	qty		= 0;

	gsc_label(name);
	errs	+= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_CHANNEL_QTY, &qty);

	if (index >= qty)
	{
		printf("SKIPPED <---  (Not supported on this device.)\n");
	}
	else
	{
		errs	+= _service_test(fd, index, name, cmd, reg);

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}



//*****************************************************************************
int tt_thr_00_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 0, "AI32SSC_IOCTL_TT_THR_00", AI32SSC_IOCTL_TT_THR_00, AI32SSC_GSC_TTC00TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_01_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 1, "AI32SSC_IOCTL_TT_THR_01", AI32SSC_IOCTL_TT_THR_01, AI32SSC_GSC_TTC01TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_02_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 2, "AI32SSC_IOCTL_TT_THR_02", AI32SSC_IOCTL_TT_THR_02, AI32SSC_GSC_TTC02TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_03_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 3, "AI32SSC_IOCTL_TT_THR_03", AI32SSC_IOCTL_TT_THR_03, AI32SSC_GSC_TTC03TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_04_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 4, "AI32SSC_IOCTL_TT_THR_04", AI32SSC_IOCTL_TT_THR_04, AI32SSC_GSC_TTC04TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_05_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 5, "AI32SSC_IOCTL_TT_THR_05", AI32SSC_IOCTL_TT_THR_05, AI32SSC_GSC_TTC05TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_06_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 6, "AI32SSC_IOCTL_TT_THR_06", AI32SSC_IOCTL_TT_THR_06, AI32SSC_GSC_TTC06TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_07_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 7, "AI32SSC_IOCTL_TT_THR_07", AI32SSC_IOCTL_TT_THR_07, AI32SSC_GSC_TTC07TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_08_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 8, "AI32SSC_IOCTL_TT_THR_08", AI32SSC_IOCTL_TT_THR_08, AI32SSC_GSC_TTC08TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_09_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 9, "AI32SSC_IOCTL_TT_THR_09", AI32SSC_IOCTL_TT_THR_09, AI32SSC_GSC_TTC09TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_10_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 10, "AI32SSC_IOCTL_TT_THR_10", AI32SSC_IOCTL_TT_THR_10, AI32SSC_GSC_TTC10TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_11_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 11, "AI32SSC_IOCTL_TT_THR_11", AI32SSC_IOCTL_TT_THR_11, AI32SSC_GSC_TTC11TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_12_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 12, "AI32SSC_IOCTL_TT_THR_12", AI32SSC_IOCTL_TT_THR_12, AI32SSC_GSC_TTC12TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_13_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 13, "AI32SSC_IOCTL_TT_THR_13", AI32SSC_IOCTL_TT_THR_13, AI32SSC_GSC_TTC13TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_14_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 14, "AI32SSC_IOCTL_TT_THR_14", AI32SSC_IOCTL_TT_THR_14, AI32SSC_GSC_TTC14TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_15_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 15, "AI32SSC_IOCTL_TT_THR_15", AI32SSC_IOCTL_TT_THR_15, AI32SSC_GSC_TTC15TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_16_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 16, "AI32SSC_IOCTL_TT_THR_16", AI32SSC_IOCTL_TT_THR_16, AI32SSC_GSC_TTC16TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_17_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 17, "AI32SSC_IOCTL_TT_THR_17", AI32SSC_IOCTL_TT_THR_17, AI32SSC_GSC_TTC17TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_18_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 18, "AI32SSC_IOCTL_TT_THR_18", AI32SSC_IOCTL_TT_THR_18, AI32SSC_GSC_TTC18TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_19_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 19, "AI32SSC_IOCTL_TT_THR_19", AI32SSC_IOCTL_TT_THR_19, AI32SSC_GSC_TTC19TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_20_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 20, "AI32SSC_IOCTL_TT_THR_20", AI32SSC_IOCTL_TT_THR_20, AI32SSC_GSC_TTC20TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_21_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 21, "AI32SSC_IOCTL_TT_THR_21", AI32SSC_IOCTL_TT_THR_21, AI32SSC_GSC_TTC21TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_22_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 22, "AI32SSC_IOCTL_TT_THR_22", AI32SSC_IOCTL_TT_THR_22, AI32SSC_GSC_TTC22TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_23_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 23, "AI32SSC_IOCTL_TT_THR_23", AI32SSC_IOCTL_TT_THR_23, AI32SSC_GSC_TTC23TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_24_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 24, "AI32SSC_IOCTL_TT_THR_24", AI32SSC_IOCTL_TT_THR_24, AI32SSC_GSC_TTC24TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_25_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 25, "AI32SSC_IOCTL_TT_THR_25", AI32SSC_IOCTL_TT_THR_25, AI32SSC_GSC_TTC25TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_26_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 26, "AI32SSC_IOCTL_TT_THR_26", AI32SSC_IOCTL_TT_THR_26, AI32SSC_GSC_TTC26TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_27_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 27, "AI32SSC_IOCTL_TT_THR_27", AI32SSC_IOCTL_TT_THR_27, AI32SSC_GSC_TTC27TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_28_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 28, "AI32SSC_IOCTL_TT_THR_28", AI32SSC_IOCTL_TT_THR_28, AI32SSC_GSC_TTC28TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_29_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 29, "AI32SSC_IOCTL_TT_THR_29", AI32SSC_IOCTL_TT_THR_29, AI32SSC_GSC_TTC29TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_30_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 30, "AI32SSC_IOCTL_TT_THR_30", AI32SSC_IOCTL_TT_THR_30, AI32SSC_GSC_TTC30TRR);
	return(ret);
}



//*****************************************************************************
int tt_thr_31_test(int fd)
{
	int	ret;

	ret	= _tt_thr_xx_test(fd, 31, "AI32SSC_IOCTL_TT_THR_31", AI32SSC_IOCTL_TT_THR_31, AI32SSC_GSC_TTC31TRR);
	return(ret);
}


