// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/tt_ref_xx.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd, int index, const char* name, u32 cmd, u32 reg)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	cmd,
			/* arg		*/	0,
			/* reg		*/	reg,
			/* mask		*/	0xFFFF,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;
	int	i;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	for (i = 0; (errs == 0) && (i < 16); i++)
	{
		list[0].arg		= 0xFFFF ^ (0x1 << i);
		list[0].value	= list[0].arg;

		errs	+= service_ioctl_set_reg_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);

		list[0].arg		= 0x1 << i;
		list[0].value	= list[0].arg;

		errs	+= service_ioctl_set_reg_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _tt_ref_xx_test(int fd, int index, const char* name, u32 cmd, u32 reg)
{
	int	errs	= 0;
	s32	qty		= 0;

	gsc_label(name);
	errs	+= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_CHANNEL_QTY, &qty);

	if (index >= qty)
	{
		printf("SKIPPED <---  (Not supported on this device.)\n");
	}
	else
	{
		errs	+= _service_test(fd, index, name, cmd, reg);

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}



//*****************************************************************************
int tt_ref_00_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 0, "AI32SSC_IOCTL_TT_REF_00", AI32SSC_IOCTL_TT_REF_00, AI32SSC_GSC_TTC00TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_01_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 1, "AI32SSC_IOCTL_TT_REF_01", AI32SSC_IOCTL_TT_REF_01, AI32SSC_GSC_TTC01TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_02_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 2, "AI32SSC_IOCTL_TT_REF_02", AI32SSC_IOCTL_TT_REF_02, AI32SSC_GSC_TTC02TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_03_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 3, "AI32SSC_IOCTL_TT_REF_03", AI32SSC_IOCTL_TT_REF_03, AI32SSC_GSC_TTC03TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_04_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 4, "AI32SSC_IOCTL_TT_REF_04", AI32SSC_IOCTL_TT_REF_04, AI32SSC_GSC_TTC04TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_05_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 5, "AI32SSC_IOCTL_TT_REF_05", AI32SSC_IOCTL_TT_REF_05, AI32SSC_GSC_TTC05TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_06_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 6, "AI32SSC_IOCTL_TT_REF_06", AI32SSC_IOCTL_TT_REF_06, AI32SSC_GSC_TTC06TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_07_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 7, "AI32SSC_IOCTL_TT_REF_07", AI32SSC_IOCTL_TT_REF_07, AI32SSC_GSC_TTC07TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_08_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 8, "AI32SSC_IOCTL_TT_REF_08", AI32SSC_IOCTL_TT_REF_08, AI32SSC_GSC_TTC08TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_09_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 9, "AI32SSC_IOCTL_TT_REF_09", AI32SSC_IOCTL_TT_REF_09, AI32SSC_GSC_TTC09TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_10_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 10, "AI32SSC_IOCTL_TT_REF_10", AI32SSC_IOCTL_TT_REF_10, AI32SSC_GSC_TTC10TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_11_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 11, "AI32SSC_IOCTL_TT_REF_11", AI32SSC_IOCTL_TT_REF_11, AI32SSC_GSC_TTC11TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_12_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 12, "AI32SSC_IOCTL_TT_REF_12", AI32SSC_IOCTL_TT_REF_12, AI32SSC_GSC_TTC12TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_13_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 13, "AI32SSC_IOCTL_TT_REF_13", AI32SSC_IOCTL_TT_REF_13, AI32SSC_GSC_TTC13TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_14_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 14, "AI32SSC_IOCTL_TT_REF_14", AI32SSC_IOCTL_TT_REF_14, AI32SSC_GSC_TTC14TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_15_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 15, "AI32SSC_IOCTL_TT_REF_15", AI32SSC_IOCTL_TT_REF_15, AI32SSC_GSC_TTC15TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_16_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 16, "AI32SSC_IOCTL_TT_REF_16", AI32SSC_IOCTL_TT_REF_16, AI32SSC_GSC_TTC16TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_17_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 17, "AI32SSC_IOCTL_TT_REF_17", AI32SSC_IOCTL_TT_REF_17, AI32SSC_GSC_TTC17TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_18_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 18, "AI32SSC_IOCTL_TT_REF_18", AI32SSC_IOCTL_TT_REF_18, AI32SSC_GSC_TTC18TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_19_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 19, "AI32SSC_IOCTL_TT_REF_19", AI32SSC_IOCTL_TT_REF_19, AI32SSC_GSC_TTC19TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_20_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 20, "AI32SSC_IOCTL_TT_REF_20", AI32SSC_IOCTL_TT_REF_20, AI32SSC_GSC_TTC20TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_21_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 21, "AI32SSC_IOCTL_TT_REF_21", AI32SSC_IOCTL_TT_REF_21, AI32SSC_GSC_TTC21TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_22_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 22, "AI32SSC_IOCTL_TT_REF_22", AI32SSC_IOCTL_TT_REF_22, AI32SSC_GSC_TTC22TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_23_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 23, "AI32SSC_IOCTL_TT_REF_23", AI32SSC_IOCTL_TT_REF_23, AI32SSC_GSC_TTC23TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_24_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 24, "AI32SSC_IOCTL_TT_REF_24", AI32SSC_IOCTL_TT_REF_24, AI32SSC_GSC_TTC24TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_25_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 25, "AI32SSC_IOCTL_TT_REF_25", AI32SSC_IOCTL_TT_REF_25, AI32SSC_GSC_TTC25TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_26_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 26, "AI32SSC_IOCTL_TT_REF_26", AI32SSC_IOCTL_TT_REF_26, AI32SSC_GSC_TTC26TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_27_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 27, "AI32SSC_IOCTL_TT_REF_27", AI32SSC_IOCTL_TT_REF_27, AI32SSC_GSC_TTC27TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_28_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 28, "AI32SSC_IOCTL_TT_REF_28", AI32SSC_IOCTL_TT_REF_28, AI32SSC_GSC_TTC28TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_29_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 29, "AI32SSC_IOCTL_TT_REF_29", AI32SSC_IOCTL_TT_REF_29, AI32SSC_GSC_TTC29TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_30_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 30, "AI32SSC_IOCTL_TT_REF_30", AI32SSC_IOCTL_TT_REF_30, AI32SSC_GSC_TTC30TRR);
	return(ret);
}



//*****************************************************************************
int tt_ref_31_test(int fd)
{
	int	ret;

	ret	= _tt_ref_xx_test(fd, 31, "AI32SSC_IOCTL_TT_REF_31", AI32SSC_IOCTL_TT_REF_31, AI32SSC_GSC_TTC31TRR);
	return(ret);
}


