// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/tt_nrate.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_NRATE,
			/* arg		*/	0xFFFFF,
			/* reg		*/	AI32SSC_GSC_TTRDR,
			/* mask		*/	0xFFFFF,
			/* value	*/	0xFFFFF
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_NRATE,
			/* arg		*/	0xF0000,
			/* reg		*/	AI32SSC_GSC_TTRDR,
			/* mask		*/	0xFFFFF,
			/* value	*/	0xF0000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_NRATE,
			/* arg		*/	0x0F000,
			/* reg		*/	AI32SSC_GSC_TTRDR,
			/* mask		*/	0xFFFFF,
			/* value	*/	0x0F000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_NRATE,
			/* arg		*/	0x00F00,
			/* reg		*/	AI32SSC_GSC_TTRDR,
			/* mask		*/	0xFFFFF,
			/* value	*/	0x00F00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_NRATE,
			/* arg		*/	0x000F0,
			/* reg		*/	AI32SSC_GSC_TTRDR,
			/* mask		*/	0xFFFFF,
			/* value	*/	0x000F0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_NRATE,
			/* arg		*/	0x0000F,
			/* reg		*/	AI32SSC_GSC_TTRDR,
			/* mask		*/	0xFFFFF,
			/* value	*/	0x0000F
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_NRATE,
			/* arg		*/	0x00002,
			/* reg		*/	AI32SSC_GSC_TTRDR,
			/* mask		*/	0xFFFFF,
			/* value	*/	0x00002
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_reg_get_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= service_ioctl_reg_get_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	// This requires external equipment to test.
	return(0);
}




/******************************************************************************
*
*	Function:	tt_nrate_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_TT_NRATE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int tt_nrate_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_TT_NRATE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


