// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/tt_log_mode.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_LOG_MODE,
			/* arg		*/	AI32SSC_TT_LOG_MODE_TRIG,
			/* reg		*/	AI32SSC_GSC_TTCR,
			/* mask		*/	0x40,
			/* value	*/	0x00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_LOG_MODE,
			/* arg		*/	AI32SSC_TT_LOG_MODE_ALL,
			/* reg		*/	AI32SSC_GSC_TTCR,
			/* mask		*/	0x40,
			/* value	*/	0x40
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	tt_log_mode_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_TT_LOG_MODE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int tt_log_mode_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_TT_LOG_MODE");
	errs	+= _service_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


