// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/tt_enable.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_ENABLE,
			/* arg		*/	AI32SSC_TT_ENABLE_NO,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x100000,
			/* value	*/	0x000000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_ENABLE,
			/* arg		*/	AI32SSC_TT_ENABLE_YES,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x100000,
			/* value	*/	0x100000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	tt_enable_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_TT_ENABLE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int tt_enable_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_TT_ENABLE");
	errs	+= _service_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


