// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/tt_chan_mask.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd, s32 qty)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_TT_CHAN_MASK,
			/* arg		*/	0x0000FFFF,
			/* reg		*/	AI32SSC_GSC_TTACMR,
			/* mask		*/	0xFFFFFFFF,
			/* value	*/	0x0000FFFF
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	i;
	u32	mask;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	mask			= 0xFFFFFFFF >> (32 - qty);
	list[0].mask	= mask;

	for (i = 0; (errs == 0) && (i < qty); i++)
	{
		list[0].arg		= mask ^ (0x1 << i);
		list[0].value	= list[0].arg;

		errs	+= service_ioctl_set_reg_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);

		list[0].arg		= 0x1 << i;
		list[0].value	= list[0].arg;

		errs	+= service_ioctl_set_reg_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	tt_chan_mask_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_TT_CHAN_MASK.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int tt_chan_mask_test(int fd)
{
	int	errs	= 0;
	s32	qty		= 0;
	s32	tt		= 0;

	gsc_label("AI32SSC_IOCTL_TT_CHAN_MASK");
	errs	+= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_CHANNEL_QTY, &qty);
	errs	+= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_TIME_TAG, &tt);

	if (tt == 0)
	{
		printf("SKIPPED <---  (Not supported on this device.)\n");
	}
	else
	{
		errs	+= _service_test(fd, qty);

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}


