// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/tt.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



/******************************************************************************
*
*	Function:	tt_tests
*
*	Purpose:
*
*		Perform tests of the Time Tag IOCTL services.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int tt_tests(int fd)
{
	int	errs	= 0;
	s32	tt		= 0;

	gsc_label("Time Tag Service Tests");
	errs	+= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_TIME_TAG, &tt);

	if (tt == 0)
	{
		printf("SKIPPED <---  (Not supported on this device.)\n");
	}
	else
	{
		printf("\n");
		gsc_label_level_inc();

		errs	+= tt_adc_clk_src_test(fd);			// AI32SSC_IOCTL_TT_ADC_CLK_SRC
		errs	+= tt_adc_enable_test(fd);			// AI32SSC_IOCTL_TT_ADC_ENABLE
		errs	+= tt_chan_mask_test(fd);			// AI32SSC_IOCTL_TT_CHAN_MASK
		errs	+= tt_enable_test(fd);				// AI32SSC_IOCTL_TT_ENABLE
		errs	+= tt_log_mode_test(fd);			// AI32SSC_IOCTL_TT_LOG_MODE
		errs	+= tt_ref_clk_src_test(fd);			// AI32SSC_IOCTL_TT_REF_CLK_SRC
		errs	+= tt_ref_val_mode_test(fd);		// AI32SSC_IOCTL_TT_REF_VAL_MODE
		errs	+= tt_reset_test(fd);				// AI32SSC_IOCTL_TT_RESET
		errs	+= tt_reset_ext_test(fd);			// AI32SSC_IOCTL_TT_RESET_EXT
		errs	+= tt_tagging_test(fd);				// AI32SSC_IOCTL_TT_TAGGING
		errs	+= tt_trig_mode_test(fd);			// AI32SSC_IOCTL_TT_TRIG_MODE
		errs	+= tt_nrate_test(fd);				// AI32SSC_IOCTL_TT_NRATE

		errs	+= tt_ref_00_test(fd);				// AI32SSC_IOCTL_TT_REF_00
		errs	+= tt_ref_01_test(fd);				// AI32SSC_IOCTL_TT_REF_01
		errs	+= tt_ref_02_test(fd);				// AI32SSC_IOCTL_TT_REF_02
		errs	+= tt_ref_03_test(fd);				// AI32SSC_IOCTL_TT_REF_03
		errs	+= tt_ref_04_test(fd);				// AI32SSC_IOCTL_TT_REF_04
		errs	+= tt_ref_05_test(fd);				// AI32SSC_IOCTL_TT_REF_05
		errs	+= tt_ref_06_test(fd);				// AI32SSC_IOCTL_TT_REF_06
		errs	+= tt_ref_07_test(fd);				// AI32SSC_IOCTL_TT_REF_07
		errs	+= tt_ref_08_test(fd);				// AI32SSC_IOCTL_TT_REF_08
		errs	+= tt_ref_09_test(fd);				// AI32SSC_IOCTL_TT_REF_09
		errs	+= tt_ref_10_test(fd);				// AI32SSC_IOCTL_TT_REF_10
		errs	+= tt_ref_11_test(fd);				// AI32SSC_IOCTL_TT_REF_11
		errs	+= tt_ref_12_test(fd);				// AI32SSC_IOCTL_TT_REF_12
		errs	+= tt_ref_13_test(fd);				// AI32SSC_IOCTL_TT_REF_13
		errs	+= tt_ref_14_test(fd);				// AI32SSC_IOCTL_TT_REF_14
		errs	+= tt_ref_15_test(fd);				// AI32SSC_IOCTL_TT_REF_15
		errs	+= tt_ref_16_test(fd);				// AI32SSC_IOCTL_TT_REF_16
		errs	+= tt_ref_17_test(fd);				// AI32SSC_IOCTL_TT_REF_17
		errs	+= tt_ref_18_test(fd);				// AI32SSC_IOCTL_TT_REF_18
		errs	+= tt_ref_19_test(fd);				// AI32SSC_IOCTL_TT_REF_19
		errs	+= tt_ref_20_test(fd);				// AI32SSC_IOCTL_TT_REF_20
		errs	+= tt_ref_21_test(fd);				// AI32SSC_IOCTL_TT_REF_21
		errs	+= tt_ref_22_test(fd);				// AI32SSC_IOCTL_TT_REF_22
		errs	+= tt_ref_23_test(fd);				// AI32SSC_IOCTL_TT_REF_23
		errs	+= tt_ref_24_test(fd);				// AI32SSC_IOCTL_TT_REF_24
		errs	+= tt_ref_25_test(fd);				// AI32SSC_IOCTL_TT_REF_25
		errs	+= tt_ref_26_test(fd);				// AI32SSC_IOCTL_TT_REF_26
		errs	+= tt_ref_27_test(fd);				// AI32SSC_IOCTL_TT_REF_27
		errs	+= tt_ref_28_test(fd);				// AI32SSC_IOCTL_TT_REF_28
		errs	+= tt_ref_29_test(fd);				// AI32SSC_IOCTL_TT_REF_29
		errs	+= tt_ref_30_test(fd);				// AI32SSC_IOCTL_TT_REF_30
		errs	+= tt_ref_31_test(fd);				// AI32SSC_IOCTL_TT_REF_31

		errs	+= tt_thr_00_test(fd);				// AI32SSC_IOCTL_TT_THR_00
		errs	+= tt_thr_01_test(fd);				// AI32SSC_IOCTL_TT_THR_01
		errs	+= tt_thr_02_test(fd);				// AI32SSC_IOCTL_TT_THR_02
		errs	+= tt_thr_03_test(fd);				// AI32SSC_IOCTL_TT_THR_03
		errs	+= tt_thr_04_test(fd);				// AI32SSC_IOCTL_TT_THR_04
		errs	+= tt_thr_05_test(fd);				// AI32SSC_IOCTL_TT_THR_05
		errs	+= tt_thr_06_test(fd);				// AI32SSC_IOCTL_TT_THR_06
		errs	+= tt_thr_07_test(fd);				// AI32SSC_IOCTL_TT_THR_07
		errs	+= tt_thr_08_test(fd);				// AI32SSC_IOCTL_TT_THR_08
		errs	+= tt_thr_09_test(fd);				// AI32SSC_IOCTL_TT_THR_09
		errs	+= tt_thr_10_test(fd);				// AI32SSC_IOCTL_TT_THR_10
		errs	+= tt_thr_11_test(fd);				// AI32SSC_IOCTL_TT_THR_11
		errs	+= tt_thr_12_test(fd);				// AI32SSC_IOCTL_TT_THR_12
		errs	+= tt_thr_13_test(fd);				// AI32SSC_IOCTL_TT_THR_13
		errs	+= tt_thr_14_test(fd);				// AI32SSC_IOCTL_TT_THR_14
		errs	+= tt_thr_15_test(fd);				// AI32SSC_IOCTL_TT_THR_15
		errs	+= tt_thr_16_test(fd);				// AI32SSC_IOCTL_TT_THR_16
		errs	+= tt_thr_17_test(fd);				// AI32SSC_IOCTL_TT_THR_17
		errs	+= tt_thr_18_test(fd);				// AI32SSC_IOCTL_TT_THR_18
		errs	+= tt_thr_19_test(fd);				// AI32SSC_IOCTL_TT_THR_19
		errs	+= tt_thr_20_test(fd);				// AI32SSC_IOCTL_TT_THR_20
		errs	+= tt_thr_21_test(fd);				// AI32SSC_IOCTL_TT_THR_21
		errs	+= tt_thr_22_test(fd);				// AI32SSC_IOCTL_TT_THR_22
		errs	+= tt_thr_23_test(fd);				// AI32SSC_IOCTL_TT_THR_23
		errs	+= tt_thr_24_test(fd);				// AI32SSC_IOCTL_TT_THR_24
		errs	+= tt_thr_25_test(fd);				// AI32SSC_IOCTL_TT_THR_25
		errs	+= tt_thr_26_test(fd);				// AI32SSC_IOCTL_TT_THR_26
		errs	+= tt_thr_27_test(fd);				// AI32SSC_IOCTL_TT_THR_27
		errs	+= tt_thr_28_test(fd);				// AI32SSC_IOCTL_TT_THR_28
		errs	+= tt_thr_29_test(fd);				// AI32SSC_IOCTL_TT_THR_29
		errs	+= tt_thr_30_test(fd);				// AI32SSC_IOCTL_TT_THR_30
		errs	+= tt_thr_31_test(fd);				// AI32SSC_IOCTL_TT_THR_31

		gsc_label_level_dec();
	}

	return(errs);
}


