// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/scan_marker_val.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_SCAN_MARKER_VAL,
			/* arg		*/	0,	// Set below.
			/* reg		*/	0,	// Set below.
			/* mask		*/	0xFFFF,
			/* value	*/	0	// Set below.
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;
	int	i;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	// Walking one: Lower Word
	list[0].reg	= AI32SSC_GSC_SMLWR;

	for (i = 0; i <= 15; i++)
	{
		list[0].arg		= 0x1UL << i;
		list[0].value	= list[0].arg & 0xFFFF;

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);
	}

	// Walking one: Upper Word
	list[0].reg	= AI32SSC_GSC_SMUWR;

	for (i = 16; i <= 31; i++)
	{
		list[0].arg		= 0x1UL << i;
		list[0].value	= (list[0].arg >> 16) & 0xFFFF;

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_sub_test(int fd, u32 value)
{
	service_data_t	list[]	=
	{
		// Test: packed, scan marker on, 8 samples, fifo size = 5, marker val = 0

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INITIALIZE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Scan channels 0-7
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x3
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_DATA_PACKING,
			/* arg		*/	AI32SSC_DATA_PACKING_ENABLE,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x40000,
			/* value	*/	0x40000
		},
		{					// Enable the scan marker.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_SCAN_MARKER,
			/* arg		*/	AI32SSC_SCAN_MARKER_ENABLE,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Set the scan marker value.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_SCAN_MARKER_VAL,
			/* arg		*/	value,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait for possible data reception.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Check the results
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	AI32SSC_GSC_BUFSR,
			/* mask		*/	0x7FFFF,
			/* value	*/	0x00005
		},
		{				// Check the results
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	AI32SSC_GSC_IBDR,
			/* mask		*/	0xFFFFFFFF,
			/* value	*/	value
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{

	int errs	= 0;

	errs	+= _function_sub_test(fd, 0x00000000);
	errs	+= _function_sub_test(fd, 0x12345675);

	return(errs);
}




/******************************************************************************
*
*	Function:	scan_marker_val_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_SCAN_MARKER_VAL.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int scan_marker_val_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_SCAN_MARKER_VAL");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


