// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/rx_io_underflow.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_UNDERFLOW,
			/* arg		*/	AI32SSC_IO_UNDERFLOW_IGNORE,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_UNDERFLOW,
			/* arg		*/	AI32SSC_IO_UNDERFLOW_CHECK,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		{				// Force an underflow
			/* service	*/	SERVICE_REG_READ,
			/* cmd		*/	0,
			/* arg		*/	2,
			/* reg		*/	AI32SSC_GSC_IBDR,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that we got an underflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x10000,
			/* value	*/	0x10000
		},
		{				// Ignore the underflow
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_UNDERFLOW,
			/* arg		*/	AI32SSC_IO_UNDERFLOW_IGNORE,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Select PIO mode.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_MODE,
			/* arg		*/	GSC_IO_MODE_PIO,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Set a low timeout period.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		{				// Verify that we got an underflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x10000,
			/* value	*/	0x10000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_UNDERFLOW,
			/* arg		*/	AI32SSC_IO_UNDERFLOW_CHECK,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	u32	data[1];
	int	errs	= 0;
	int	i;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= service_ioctl_set_reg_list(fd, list_1);

	if (errs == 0)
	{
		i	= ai32ssc_read(fd, &data, 4);

		if (i != 0)
		{
			errs++;
			printf("FAIL <---  (ai32ssc_read(): returned %d, expected 0)\n", i);
		}
	}

	errs	+= service_ioctl_set_reg_list(fd, list_2);

	if (errs == 0)
	{
		i	= ai32ssc_read(fd, &data, 4);

		if (i >= 0)
		{
			errs++;
			printf("FAIL <---  (ai32ssc_read(): returned %d, expected < 0)\n", i);
		}
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	rx_io_underflow_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_RX_IO_UNDERFLOW.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int rx_io_underflow_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_RX_IO_UNDERFLOW");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


