// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/rx_io_timeout.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	AI32SSC_IO_TIMEOUT_MAX,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	(AI32SSC_IO_TIMEOUT_MIN + AI32SSC_IO_TIMEOUT_MAX) / 2,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	AI32SSC_IO_TIMEOUT_MIN,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	AI32SSC_IO_TIMEOUT_NO_SLEEP,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	AI32SSC_IO_TIMEOUT_DEFAULT,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	#define	TIEMOUT_1	2
	#define	TIEMOUT_2	6

	static const service_data_t	list_1[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	TIEMOUT_1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_TIMEOUT,
			/* arg		*/	TIEMOUT_2,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	u32		data[1];
	long	dt1;
	long	dt2;
	int		errs	= 0;
	int		i;
	time_t	t1;
	time_t	t2;
	time_t	t3;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= service_ioctl_set_get_list(fd, list_1);
	t1		= time(NULL);

	if (errs == 0)
	{
		i	= ai32ssc_read(fd, &data, 4);

		if (i != 0)
		{
			errs++;
			printf(	"FAIL <---  (%d. ai32ssc_read(): returned %d, expected 0)\n",
					__LINE__,
					i);
		}
	}

	errs	+= service_ioctl_set_get_list(fd, list_2);
	t2		= time(NULL);

	if (errs == 0)
	{
		i	= ai32ssc_read(fd, &data, 4);

		if (i != 0)
		{
			errs++;
			printf(	"FAIL <---  (%d. ai32ssc_read(): returned %d, expected 0)\n",
					__LINE__,
					i);
		}
	}

	t3	= time(NULL);
	dt1	= t2 - t1;
	dt2	= t3 - t2;

	if (errs)
	{
	}
	else if ((dt1 < (TIEMOUT_1 - 1)) || (dt1 > (TIEMOUT_1 + 1)))
	{
		errs++;
		printf(	"FAIL <---  (%d. timeout was %ld, expected %ld to %ld)\n",
				__LINE__,
				dt1,
				(long) TIEMOUT_1 - 1,
				(long) TIEMOUT_1 + 1);
	}
	else if ((dt2 < (TIEMOUT_2 - 1)) || (dt2 > (TIEMOUT_2 + 1)))
	{
		errs++;
		printf(	"FAIL <---  (%d. timeout was %ld, expected %ld to %ld)\n",
				__LINE__,
				dt2,
				(long) TIEMOUT_2 - 1,
				(long) TIEMOUT_2 + 1);
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	rx_io_timeout_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_RX_IO_TIMEOUT.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int rx_io_timeout_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_RX_IO_TIMEOUT");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


