// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/rx_io_overflow.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_OVERFLOW,
			/* arg		*/	AI32SSC_IO_OVERFLOW_IGNORE,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_OVERFLOW,
			/* arg		*/	AI32SSC_IO_OVERFLOW_CHECK,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= service_ioctl_set_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		{				// Enable Rate-A Generator
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_RAGR,
			/* mask		*/	0x10000,
			/* value	*/	0x00000
		},
		{				// ADC source = Rate-A Generator.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x08
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{				// Wait to see if we get any data.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	2,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that we got an overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x20000,
			/* value	*/	0x20000
		},
		{				// Verify that we got an overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x20000,
			/* value	*/	0x20000
		},
		{				// Ignore the overflow
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_OVERFLOW,
			/* arg		*/	AI32SSC_IO_OVERFLOW_IGNORE,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Select PIO mode.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_MODE,
			/* arg		*/	GSC_IO_MODE_PIO,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		{				// Verify that we got an overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x20000,
			/* value	*/	0x20000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RX_IO_OVERFLOW,
			/* arg		*/	AI32SSC_IO_OVERFLOW_CHECK,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	u32	data[1];
	int	errs	= 0;
	int	i;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= service_ioctl_set_reg_list(fd, list_1);

	if (errs == 0)
	{
		i	= ai32ssc_read(fd, &data, 4);

		if (i != 4)
		{
			errs++;
			printf("FAIL <---  (ai32ssc_read(): returned %d, expected 4)\n", i);
		}
	}

	errs	+= service_ioctl_set_reg_list(fd, list_2);

	if (errs == 0)
	{
		i	= ai32ssc_read(fd, &data, 4);

		if (i >= 0)
		{
			errs++;
			printf("FAIL <---  (ai32ssc_read(): returned %d, expected -1)\n", i);
		}
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	rx_io_overflow_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_RX_IO_OVERFLOW.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int rx_io_overflow_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_RX_IO_OVERFLOW");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


