// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/reg_mod.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



/******************************************************************************
*
*	Function:	reg_mod_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_REG_MOD.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int reg_mod_test(int fd)
{
	static const struct
	{
		u32	reg;
		u32	mask;
	} list[]	=
	{
		// reg					mask
		{ AI32SSC_GSC_BCTLR,	0x00140877	},
		{ AI32SSC_GSC_SSCR,		0x0000FF3F	},
	};

	u32			bit;
	int			errs	= 0;
	int			i;
	int			j;
	gsc_reg_t	parm;
	u32			value;

	gsc_label("AI32SSC_IOCTL_REG_MOD");

	for (i = 0; (errs == 0) && (i < SIZEOF_ARRAY(list)); i++)
	{

		for (bit = 0x1; bit; bit <<= 1)
		{
			if ((list[i].mask & bit) == 0)
				continue;

			// Read the register value so we can restore it later.
			parm.reg	= list[i].reg;
			j			= ai32ssc_ioctl(fd, AI32SSC_IOCTL_REG_READ, (void*) &parm);
			value		= parm.value;

			if (j)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, ai32ssc_ioctl() failure, errno %d)\n",
						__LINE__,
						i,
						errno);
				break;
			}

			// Set the bit low.
			parm.value	= 0;
			parm.mask	= bit;
			j			= ai32ssc_ioctl(fd, AI32SSC_IOCTL_REG_MOD, (void*) &parm);

			if (j)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, ai32ssc_ioctl() failure, errno %d)\n",
						__LINE__,
						i,
						errno);
				break;
			}

			// Now verify that the bit is low.
			j	= ai32ssc_ioctl(fd, AI32SSC_IOCTL_REG_READ, (void*) &parm);

			if (j)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, ai32ssc_ioctl() failure, errno %d)\n",
						__LINE__,
						i,
						errno);
				break;
			}

			if (parm.value & bit)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, bit not low, mask 0x%lX, got 0x%lX)\n",
						__LINE__,
						i,
						(long) bit,
						(long) parm.value);
				break;
			}

			// Now restore the register to its previous value.
			parm.value	= value;
			j			= ai32ssc_ioctl(fd, AI32SSC_IOCTL_REG_WRITE, (void*) &parm);

			if (j)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, ai32ssc_ioctl() failure, errno %d)\n",
						__LINE__,
						i,
						errno);
				break;
			}

			// Set the bit high.
			parm.value	= bit;
			parm.mask	= bit;
			j			= ai32ssc_ioctl(fd, AI32SSC_IOCTL_REG_MOD, (void*) &parm);

			if (j)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, ai32ssc_ioctl() failure, errno %d)\n",
						__LINE__,
						i,
						errno);
				break;
			}

			// Now verify that the bit is high.
			j	= ai32ssc_ioctl(fd, AI32SSC_IOCTL_REG_READ, (void*) &parm);

			if (j)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, ai32ssc_ioctl() failure, errno %d)\n",
						__LINE__,
						i,
						errno);
				break;
			}

			if ((parm.value & bit) == 0)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, bit not high, mask 0x%lX, got 0x%lX)\n",
						__LINE__,
						i,
						(long) bit,
						(long) parm.value);
				break;
			}

			// Now restore the register to its previous value.
			parm.value	= value;
			j			= ai32ssc_ioctl(fd, AI32SSC_IOCTL_REG_WRITE, (void*) &parm);

			if (j)
			{
				errs	= 1;
				printf(	"FAIL <---  (%d. i %d, ai32ssc_ioctl() failure, errno %d)\n",
						__LINE__,
						i,
						errno);
				break;
			}
		}
	}

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


