// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/rbg_sync_output.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RBG_SYNC_OUTPUT,
			/* arg		*/	AI32SSC_RBG_SYNC_OUTPUT_DISABLE,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x40,
			/* value	*/	0x00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_RBG_SYNC_OUTPUT,
			/* arg		*/	AI32SSC_RBG_SYNC_OUTPUT_ENABLE,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x40,
			/* value	*/	0x40
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_reg_get_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= service_ioctl_reg_get_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	// This requires external equipment to test.
	return(0);
}




/******************************************************************************
*
*	Function:	rbg_sync_output_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_RBG_SYNC_OUTPUT.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int rbg_sync_output_test(int fd)
{
	int	errs;
	s32	sync;

	gsc_label("AI32SSC_IOCTL_RBG_SYNC_OUTPUT");
	errs	= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_RBG_SYNC_OUTPUT, &sync);

	if (errs)
	{
	}
	else if (sync == 0)
	{
		printf("SKIPPED  (Not supported on this device.)\n");
	}
	else
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}

	return(errs);
}


