// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/query.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



/******************************************************************************
*
*	Function:	query_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_QUERY. We test only the
*		overall service, not the values returned.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int query_test(int fd)
{
	s32	data;
	s32	count;
	int	errs;
	int	i;

	gsc_label("AI32SSC_IOCTL_QUERY");
	errs	= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_COUNT, &count);

	if (count != AI32SSC_IOCTL_QUERY_LAST)
	{
		errs	= 1;
		printf(	"FAIL <---  (expected %ld, got %ld, rebuild application)\n",
				(long) AI32SSC_IOCTL_QUERY_LAST,
				(long) count);
	}
	else
	{
		for (i = 0; i < AI32SSC_IOCTL_QUERY_LAST; i++)
			errs	= ai32ssc_query(fd, -1, 0, i, &data);

		if (errs)
			printf("FAIL <---  (%d errors)\n", errs);
		else
			printf("PASS\n");

		errs	= errs ? 1 : 0;
	}

	return(errs);
}


