// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/perform.c $
// $Rev: 53697 $
// $Date: 2023-09-07 13:52:59 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;

	errs	+= reg_read_test(args->fd);				// AI32SSC_IOCTL_REG_READ
	errs	+= reg_write_test(args->fd);			// AI32SSC_IOCTL_REG_WRITE
	errs	+= reg_mod_test(args->fd);				// AI32SSC_IOCTL_REG_MOD
	errs	+= query_test(args->fd);				// AI32SSC_IOCTL_QUERY
	errs	+= initialize_test(args->fd);			// AI32SSC_IOCTL_INITIALIZE
	errs	+= autocal_test(args->fd);				// AI32SSC_IOCTL_AUTOCAL

	errs	+= rx_io_abort_test(args->fd);			// AI32SSC_IOCTL_RX_IO_ABORT
	errs	+= rx_io_mode_test(args->fd);			// AI32SSC_IOCTL_RX_IO_MODE
	errs	+= rx_io_overflow_test(args->fd);		// AI32SSC_IOCTL_RX_IO_OVERFLOW
	errs	+= rx_io_timeout_test(args->fd);		// AI32SSC_IOCTL_RX_IO_TIMEOUT
	errs	+= rx_io_underflow_test(args->fd);		// AI32SSC_IOCTL_RX_IO_UNDERFLOW

	errs	+= adc_clk_src_test(args->fd);			// AI32SSC_IOCTL_ADC_CLK_SRC
	errs	+= adc_enable_test(args->fd);			// AI32SSC_IOCTL_ADC_ENABLE
	errs	+= ain_buf_clear_test(args->fd);		// AI32SSC_IOCTL_AIN_BUF_CLEAR
	errs	+= ain_buf_level_test(args->fd);		// AI32SSC_IOCTL_AIN_BUF_LEVEL
	errs	+= ain_buf_overflow_test(args->fd);		// AI32SSC_IOCTL_AIN_BUF_OVERFLOW
	errs	+= ain_buf_thr_lvl_test(args->fd);		// AI32SSC_IOCTL_AIN_BUF_THR_LVL
	errs	+= ain_buf_thr_sts_test(args->fd);		// AI32SSC_IOCTL_AIN_BUF_THR_STS
	errs	+= ain_buf_underflow_test(args->fd);	// AI32SSC_IOCTL_AIN_BUF_UNDERFLOW
	errs	+= ain_mode_test(args->fd);				// AI32SSC_IOCTL_AIN_MODE
	errs	+= ain_range_test(args->fd);			// AI32SSC_IOCTL_AIN_RANGE
	errs	+= burst_busy_test(args->fd);			// AI32SSC_IOCTL_BURST_BUSY
	errs	+= burst_sync_test(args->fd);			// AI32SSC_IOCTL_BURST_SYNC
	errs	+= chan_active_test(args->fd);			// AI32SSC_IOCTL_CHAN_ACTIVE
	errs	+= chan_first_test(args->fd);			// AI32SSC_IOCTL_CHAN_FIRST
	errs	+= chan_last_test(args->fd);			// AI32SSC_IOCTL_CHAN_LAST
	errs	+= chan_single_test(args->fd);			// AI32SSC_IOCTL_CHAN_SINGLE
	errs	+= data_format_test(args->fd);			// AI32SSC_IOCTL_DATA_FORMAT
	errs	+= data_packing_test(args->fd);			// AI32SSC_IOCTL_DATA_PACKING
	errs	+= input_sync_test(args->fd);			// AI32SSC_IOCTL_INPUT_SYNC
	errs	+= io_inv_test(args->fd);				// AI32SSC_IOCTL_IO_INV
	errs	+= irq0_sel_test(args->fd);				// AI32SSC_IOCTL_IRQ0_SEL
	errs	+= irq1_sel_test(args->fd);				// AI32SSC_IOCTL_IRQ1_SEL
	errs	+= rag_enable_test(args->fd);			// AI32SSC_IOCTL_RAG_ENABLE
	errs	+= rag_nrate_test(args->fd);			// AI32SSC_IOCTL_RAG_NRATE
	errs	+= rbg_clk_src_test(args->fd);			// AI32SSC_IOCTL_RBG_CLK_SRC
	errs	+= rbg_enable_test(args->fd);			// AI32SSC_IOCTL_RBG_ENABLE
	errs	+= rbg_nrate_test(args->fd);			// AI32SSC_IOCTL_RBG_NRATE
	errs	+= rbg_sync_output_test(args->fd);		// AI32SSC_IOCTL_RBG_SYNC_OUTPUT
	errs	+= scan_marker_test(args->fd);			// AI32SSC_IOCTL_SCAN_MARKER
	errs	+= scan_marker_val_test(args->fd);		// AI32SSC_IOCTL_SCAN_MARKER_VAL

	errs	+= aux_tests(args->fd);
	errs	+= tt_tests(args->fd);

	errs	+= wait_event_test(args->fd);			// AI32SSC_IOCTL_WAIT_EVENT
	errs	+= wait_cancel_test(args->fd);			// AI32SSC_IOCTL_WAIT_CANCEL
	errs	+= wait_status_test(args->fd);			// AI32SSC_IOCTL_WAIT_STATUS

	return(errs);
}


