// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/main.h $
// $Rev: 53697 $
// $Date: 2023-09-07 13:52:59 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <errno.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "16ai32ssc_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for the device to access.

	// Device Settings

} args_t;

typedef enum
{
	SERVICE_END_LIST,	// Ends list of service_data_t structures.
	SERVICE_NORMAL,
	SERVICE_REG_MOD,
	SERVICE_REG_READ,
	SERVICE_REG_SHOW,
	SERVICE_REG_TEST,
	SERVICE_SLEEP,
	SERVICE_SLEEP_MS,
	SERVICE_IOCTL_GET,
	SERVICE_IOCTL_SET
} service_t;

typedef struct
{
	service_t		service;
	unsigned long	cmd;	// IOCTL code
	s32				arg;	// The IOCTL data argument.
	u32				reg;	// The register to access. Use -1 to ignore.
	u32				mask;	// The register bits of interest.
	u32				value;	// The value expected for the bits of interest.
} service_data_t;



// prototypes *****************************************************************

int	adc_clk_src_test(int fd);
int	adc_enable_test(int fd);
int	ain_buf_clear_test(int fd);
int	ain_buf_level_test(int fd);
int	ain_buf_overflow_test(int fd);
int	ain_buf_thr_lvl_test(int fd);
int	ain_buf_thr_sts_test(int fd);
int	ain_buf_underflow_test(int fd);
int	ain_mode_test(int fd);
int	ain_range_test(int fd);
int	autocal_test(int fd);
int	aux_clk_mode_test(int fd);
int	aux_in_pol_test(int fd);
int	aux_noise_test(int fd);
int	aux_out_pol_test(int fd);
int	aux_sync_mode_test(int fd);
int	aux_tests(int fd);

int	burst_busy_test(int fd);
int	burst_sync_test(int fd);

int	chan_active_test(int fd);
int	chan_first_test(int fd);
int	chan_last_test(int fd);
int	chan_single_test(int fd);

int	data_format_test(int fd);
int	data_packing_test(int fd);

int	initialize_test(int fd);
int	input_sync_test(int fd);
int	io_inv_test(int fd);
int	irq0_sel_test(int fd);
int	irq1_sel_test(int fd);

int	perform_tests(const args_t* args);

int	query_test(int fd);

int	rag_enable_test(int fd);
int	rag_nrate_test(int fd);
int	rbg_clk_src_test(int fd);
int	rbg_enable_test(int fd);
int	rbg_nrate_test(int fd);
int	rbg_sync_output_test(int fd);			// AI32SSC_IOCTL_RBG_SYNC_OUTPUT

int	reg_mod_test(int fd);
int	reg_read_test(int fd);
int	reg_write_test(int fd);
int	rx_io_abort_test(int fd);
int	rx_io_mode_test(int fd);
int	rx_io_overflow_test(int fd);
int	rx_io_timeout_test(int fd);
int	rx_io_underflow_test(int fd);

int	scan_marker_test(int fd);
int	scan_marker_val_test(int fd);
int	service_ioctl_reg_get_list(int fd, const service_data_t* list);
int	service_ioctl_set_get_list(int fd, const service_data_t* list);
int	service_ioctl_set_reg_list(int fd, const service_data_t* list);

int	tt_adc_clk_src_test(int fd);
int	tt_adc_enable_test(int fd);
int	tt_chan_mask_test(int fd);
int	tt_enable_test(int fd);
int	tt_log_mode_test(int fd);
int	tt_nrate_test(int fd);
int	tt_ref_clk_src_test(int fd);
int	tt_ref_val_mode_test(int fd);
int	tt_ref_00_test(int fd);
int	tt_ref_01_test(int fd);
int	tt_ref_02_test(int fd);
int	tt_ref_03_test(int fd);
int	tt_ref_04_test(int fd);
int	tt_ref_05_test(int fd);
int	tt_ref_06_test(int fd);
int	tt_ref_07_test(int fd);
int	tt_ref_08_test(int fd);
int	tt_ref_09_test(int fd);
int	tt_ref_10_test(int fd);
int	tt_ref_11_test(int fd);
int	tt_ref_12_test(int fd);
int	tt_ref_13_test(int fd);
int	tt_ref_14_test(int fd);
int	tt_ref_15_test(int fd);
int	tt_ref_16_test(int fd);
int	tt_ref_17_test(int fd);
int	tt_ref_18_test(int fd);
int	tt_ref_19_test(int fd);
int	tt_ref_20_test(int fd);
int	tt_ref_21_test(int fd);
int	tt_ref_22_test(int fd);
int	tt_ref_23_test(int fd);
int	tt_ref_24_test(int fd);
int	tt_ref_25_test(int fd);
int	tt_ref_26_test(int fd);
int	tt_ref_27_test(int fd);
int	tt_ref_28_test(int fd);
int	tt_ref_29_test(int fd);
int	tt_ref_30_test(int fd);
int	tt_ref_31_test(int fd);
int	tt_reset_ext_test(int fd);
int	tt_reset_test(int fd);
int	tt_tagging_test(int fd);
int	tt_thr_00_test(int fd);
int	tt_thr_01_test(int fd);
int	tt_thr_02_test(int fd);
int	tt_thr_03_test(int fd);
int	tt_thr_04_test(int fd);
int	tt_thr_05_test(int fd);
int	tt_thr_06_test(int fd);
int	tt_thr_07_test(int fd);
int	tt_thr_08_test(int fd);
int	tt_thr_09_test(int fd);
int	tt_thr_10_test(int fd);
int	tt_thr_11_test(int fd);
int	tt_thr_12_test(int fd);
int	tt_thr_13_test(int fd);
int	tt_thr_14_test(int fd);
int	tt_thr_15_test(int fd);
int	tt_thr_16_test(int fd);
int	tt_thr_17_test(int fd);
int	tt_thr_18_test(int fd);
int	tt_thr_19_test(int fd);
int	tt_thr_20_test(int fd);
int	tt_thr_21_test(int fd);
int	tt_thr_22_test(int fd);
int	tt_thr_23_test(int fd);
int	tt_thr_24_test(int fd);
int	tt_thr_25_test(int fd);
int	tt_thr_26_test(int fd);
int	tt_thr_27_test(int fd);
int	tt_thr_28_test(int fd);
int	tt_thr_29_test(int fd);
int	tt_thr_30_test(int fd);
int	tt_thr_31_test(int fd);
int	tt_trig_mode_test(int fd);
int	tt_tests(int fd);

int	wait_cancel_test(int fd);				// AI32SSC_IOCTL_WAIT_CANCEL
int	wait_event_test(int fd);				// AI32SSC_IOCTL_WAIT_EVENT
int	wait_status_test(int fd);				// AI32SSC_IOCTL_WAIT_STATUS



#endif
