// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/irq1_sel.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ1_SEL,
			/* arg		*/	AI32SSC_IRQ1_NONE,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x70,
			/* value	*/	0x00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ1_SEL,
			/* arg		*/	AI32SSC_IRQ1_IN_BUF_THR_L2H,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x70,
			/* value	*/	0x10
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ1_SEL,
			/* arg		*/	AI32SSC_IRQ1_IN_BUF_THR_H2L,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x70,
			/* value	*/	0x20
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ1_SEL,
			/* arg		*/	AI32SSC_IRQ1_IN_BUF_OVR_UNDR,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x70,
			/* value	*/	0x30
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	// The interrupts are verified under wait_event.c.
	return(0);
}



/******************************************************************************
*
*	Function:	irq1_sel_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_IRQ1_SEL.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int irq1_sel_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_IRQ1_SEL");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


