// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/irq0_sel.c $
// $Rev: 53697 $
// $Date: 2023-09-07 13:52:59 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ0_SEL,
			/* arg		*/	AI32SSC_IRQ0_INIT_DONE,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x7,
			/* value	*/	0x0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ0_SEL,
			/* arg		*/	AI32SSC_IRQ0_AUTOCAL_DONE,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x7,
			/* value	*/	0x1
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ0_SEL,
			/* arg		*/	AI32SSC_IRQ0_SYNC_START,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x7,
			/* value	*/	0x2
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ0_SEL,
			/* arg		*/	AI32SSC_IRQ0_SYNC_DONE,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x7,
			/* value	*/	0x3
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ0_SEL,
			/* arg		*/	AI32SSC_IRQ0_BURST_START,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x7,
			/* value	*/	0x4
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IRQ0_SEL,
			/* arg		*/	AI32SSC_IRQ0_BURST_DONE,
			/* reg		*/	AI32SSC_GSC_ICR,
			/* mask		*/	0x7,
			/* value	*/	0x5
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	// The interrupts are verified under wait_event.c.
	return(0);
}



/******************************************************************************
*
*	Function:	irq0_sel_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_IRQ0_SEL.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int irq0_sel_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_IRQ0_SEL");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


