// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/io_inv.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IO_INV,
			/* arg		*/	AI32SSC_IO_INV_LOW,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x800,
			/* value	*/	0x000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_IO_INV,
			/* arg		*/	AI32SSC_IO_INV_HIGH,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x800,
			/* value	*/	0x800
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	int errs	= 0;

	// This requires external equipment.
	return(errs);
}




/******************************************************************************
*
*	Function:	io_inv_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_IO_INV.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int io_inv_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_IO_INV");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


