// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/data_format.c $
// $Rev: 53697 $
// $Date: 2023-09-07 13:52:59 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_DATA_FORMAT,
			/* arg		*/	AI32SSC_DATA_FORMAT_2S_COMP,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x40,
			/* value	*/	0x00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_DATA_FORMAT,
			/* arg		*/	AI32SSC_DATA_FORMAT_OFF_BIN,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x40,
			/* value	*/	0x40
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		{					// Select maximum input voltage
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_MODE,
			/* arg		*/	AI32SSC_AIN_MODE_VREF,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Autocalibrate
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AUTOCAL,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{					// Data Format: Binary Offset
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_DATA_FORMAT,
			/* arg		*/	AI32SSC_DATA_FORMAT_OFF_BIN,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify the results
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	AI32SSC_GSC_IBDR,
			/* mask		*/	0x8000,
			/* value	*/	0x8000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		{					// Select maximum input voltage
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_MODE,
			/* arg		*/	AI32SSC_AIN_MODE_VREF,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Autocalibrate
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AUTOCAL,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{					// Data Format: 2s Comp
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_DATA_FORMAT,
			/* arg		*/	AI32SSC_DATA_FORMAT_2S_COMP,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify the results
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	AI32SSC_GSC_IBDR,
			/* mask		*/	0x8000,
			/* value	*/	0x0000
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list_1);

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list_2);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	data_format_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_DATA_FORMAT.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int data_format_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_DATA_FORMAT");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


