// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/chan_single.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_SINGLE,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x3F000,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	i;
	s32	qty		= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_CHANNEL_QTY, &qty);

	for (i = 0; (i < qty) && (errs == 0); i++)
	{
		list[0].arg		= i;
		list[0].value	= i << 12;

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	int	errs	= 0;

	// This test requires additional equipment.
	return(errs);
}




/******************************************************************************
*
*	Function:	chan_single_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_CHAN_SINGLE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int chan_single_test(int fd)
{
	int		errs	= 0;

	gsc_label("AI32SSC_IOCTL_CHAN_SINGLE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


