// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/chan_last.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_LAST,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_ACAR,
			/* mask		*/	0xFF00,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	i;
	s32	qty		= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_CHANNEL_QTY, &qty);

	for (i = 0; (errs == 0) && (i < qty); i++)
	{
		list[0].arg		= i;
		list[0].value	= i << 8;

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_reg_get_list(fd, list);
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_sub_test(int fd, s32 option, int samples, int first, int last)
{
	service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INITIALIZE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Select option
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_ACTIVE,
			/* arg		*/	option,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// First Channel
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_ACAR,
			/* mask		*/	0xFF,
			/* value	*/	first
		},
		{					// Last Channel
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_ACAR,
			/* mask		*/	0xFF00,
			/* value	*/	last << 8
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Check the results
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	AI32SSC_GSC_BUFSR,
			/* mask		*/	0x7FFFF,
			/* value	*/	samples
		},

		{ SERVICE_END_LIST }
	};

	int	errs;

	errs	= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	int	errs	= 0;
	int	i;
	s32	qty;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= ai32ssc_query(fd, -1, 0, AI32SSC_QUERY_CHANNEL_QTY, &qty);

	for (i = 0; (errs == 0) && (i < qty); i++)
		errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_RANGE, i + 1, 0, i);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	chan_last_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_CHAN_LAST.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int chan_last_test(int fd)
{
	int		errs	= 0;

	gsc_label("AI32SSC_IOCTL_CHAN_LAST");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


