// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/chan_active.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_ACTIVE,
			/* arg		*/	AI32SSC_CHAN_ACTIVE_SINGLE,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x0
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_ACTIVE,
			/* arg		*/	AI32SSC_CHAN_ACTIVE_0_1,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x1
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_ACTIVE,
			/* arg		*/	AI32SSC_CHAN_ACTIVE_0_3,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x2
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_ACTIVE,
			/* arg		*/	AI32SSC_CHAN_ACTIVE_0_7,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x3
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_ACTIVE,
			/* arg		*/	AI32SSC_CHAN_ACTIVE_0_15,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x4
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_ACTIVE,
			/* arg		*/	AI32SSC_CHAN_ACTIVE_RANGE,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x7
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_sub_test(int fd, s32 option, int samples, int first, int last)
{
	const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INITIALIZE,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Select option
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_CHAN_ACTIVE,
			/* arg		*/	option,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// First Channel
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_ACAR,
			/* mask		*/	0xFF,
			/* value	*/	first
		},
		{					// Last Channel
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_ACAR,
			/* mask		*/	0xFF00,
			/* value	*/	last << 8
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Check the results
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	AI32SSC_GSC_BUFSR,
			/* mask		*/	0x7FFFF,
			/* value	*/	samples
		},

		{ SERVICE_END_LIST }
	};

	int	errs;

	errs	= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_SINGLE,	1,	0,	0	);
	errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_0_1,		2,	0,	0	);
	errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_0_3,		4,	0,	0	);
	errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_0_7,		8,	0,	0	);
	errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_0_15,		16,	0,	0	);
	errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_RANGE,	2,	13,	14	);
	errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_RANGE,	6,	1,	6	);
	errs	+= _function_sub_test(fd, AI32SSC_CHAN_ACTIVE_RANGE,	10,	3,	12	);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	chan_active_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_CHAN_ACTIVE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int chan_active_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_CHAN_ACTIVE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


