// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/burst_busy.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	int errs	= 0;

	// There are no persistent bits to test with this service.
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		// Produce a short sync operation.

		{				// Scan channels 0-7
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x3
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x1000,
			/* value	*/	0x1000
		},
		{				// Wait for operation activity.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that the sync operation is done.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x1000,
			/* value	*/	0x0000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		// Produce a long sync operation.

		{				// Scan channels 0-7
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x3
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Disable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x00
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x1000,
			/* value	*/	0x1000
		},
		{				// Wait for operation activity.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that the sync operation is active.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x1000,
			/* value	*/	0x1000
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	ret;
	s32	sts;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= service_ioctl_set_reg_list(fd, list_1);

	if (errs == 0)
	{
		// Verify that the operation is complete.
		ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_BURST_BUSY, &sts);
		errs	+= ret ? 1 : 0;

		if (ret)
		{
			errs++;
		}
		else if (sts != AI32SSC_BURST_BUSY_IDLE)
		{
			errs++;
			printf(	"FAIL <---  (%d. expected idle, but still active)\n",
					__LINE__);
		}
	}

	errs	+= service_ioctl_set_reg_list(fd, list_2);

	if (errs == 0)
	{
		// Verify that the operation is still active.
		ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_BURST_BUSY, &sts);
		errs	+= ret ? 1 : 0;

		if (ret)
		{
			errs++;
		}
		else if (sts != AI32SSC_BURST_BUSY_ACTIVE)
		{
			errs++;
			printf(	"FAIL <---  (%d. expected active, but is idle)\n",
					__LINE__);
		}
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	burst_busy_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_BURST_BUSY.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int burst_busy_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_BURST_BUSY");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


