// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/aux_in_pol.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AUX_IN_POL,
			/* arg		*/	AI32SSC_AUX_IN_POL_LO_2_HI,
			/* reg		*/	AI32SSC_GSC_ASIOCR,
			/* mask		*/	0x100,
			/* value	*/	0x000
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AUX_IN_POL,
			/* arg		*/	AI32SSC_AUX_IN_POL_HI_2_LO,
			/* reg		*/	AI32SSC_GSC_ASIOCR,
			/* mask		*/	0x100,
			/* value	*/	0x100
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	int errs	= 0;

	// This test requires additional equipment.
	return(errs);
}




/******************************************************************************
*
*	Function:	aux_in_pol_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_AUX_IN_POL.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aux_in_pol_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_AUX_IN_POL");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


