// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/aux_.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aux_tests
*
*	Purpose:
*
*		Perform tests of the Auxiliary IOCTL services.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aux_tests(int fd)
{
	int	errs	= 0;

	gsc_label("Auxiliary Service Tests");
	printf("\n");
	gsc_label_level_inc();

	errs	+= aux_clk_mode_test(fd);	// AI32SSC_IOCTL_AUX_CLK_MODE
	errs	+= aux_in_pol_test(fd);		// AI32SSC_IOCTL_AUX_IN_POL
	errs	+= aux_noise_test(fd);		// AI32SSC_IOCTL_AUX_NOISE
	errs	+= aux_out_pol_test(fd);	// AI32SSC_IOCTL_AUX_OUT_POL
	errs	+= aux_sync_mode_test(fd);	// AI32SSC_IOCTL_AUX_SYNC_MODE

	gsc_label_level_dec();
	return(errs);
}


