// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/autocal.c $
// $Rev: 53697 $
// $Date: 2023-09-07 13:52:59 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AUTOCAL,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x6000,
			/* value	*/	0x4000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	int errs	= 0;

	// This would require additional equipment.
	return(errs);
}




/******************************************************************************
*
*	Function:	autocal_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_AUTOCAL. We can't
*		verify that an autocalibration was performed, so we simply check that
*		the respective bits are correct afterwards.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int autocal_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_AUTOCAL");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


