// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/ain_range.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_RANGE,
			/* arg		*/	AI32SSC_AIN_RANGE_2_5V,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x30,
			/* value	*/	0x00
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_RANGE,
			/* arg		*/	AI32SSC_AIN_RANGE_5V,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x30,
			/* value	*/	0x10
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_RANGE,
			/* arg		*/	AI32SSC_AIN_RANGE_10V,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x30,
			/* value	*/	0x20
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	int errs	= 0;

	// This test requires additional equipment.
	return(errs);
}




/******************************************************************************
*
*	Function:	ain_range_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_AIN_RANGE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ain_range_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_AIN_RANGE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


