// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/ain_buf_thr_sts.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	int errs	= 0;

	// There are no persistent bits to test with this service.
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		// Put some data in the FIFO: unpacked, 16 samples, fifo size = 8

		{				// Scan channels 0-7
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x3
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait for possible data reception.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait for possible data reception.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	service_data_t	list_2[]	=
	{
		{	// 0		// Set the threshold to the current fill level + 1.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_BUF_THR_LVL,
			/* arg		*/	0,	// SET THIS FOR EACH LOOP ITERATION.
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 1		// Verify that the threshold flag is clear.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_IBCR,
			/* mask		*/	0x80000,
			/* value	*/	0x00000
		},
		{	// 2		// Set the threshold to the current fill level + 0.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_BUF_THR_LVL,
			/* arg		*/	0,	// SET THIS FOR EACH LOOP ITERATION.
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 3		// Verify that the threshold flag is clear.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_IBCR,
			/* mask		*/	0x80000,
			/* value	*/	0x00000
		},
		{	// 4		// Set the threshold to the current fill level - 1.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_BUF_THR_LVL,
			/* arg		*/	0,	// SET THIS FOR EACH LOOP ITERATION.
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 5		// Verify that the threshold flag is set.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_IBCR,
			/* mask		*/	0x80000,
			/* value	*/	0x80000
		},
		{	// 6		// Read a value from the input buffer.
			/* service	*/	SERVICE_REG_READ,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_IBDR,
			/* mask		*/	0,
			/* value	*/	0
		},
		{	// 7		// Verify that the threshold flag is clear.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_IBCR,
			/* mask		*/	0x80000,
			/* value	*/	0x00000
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	i;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list_1);

	// We're only testing the status accuracy for a small range.

	for (i = 16; (errs == 0) && (i >= 3); i--)
	{
		list_2[0].arg	= i + 1;
		list_2[2].arg	= i;
		list_2[4].arg	= i - 1;

		errs	+= service_ioctl_set_reg_list(fd, list_2);
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	ain_buf_thr_sts_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_AIN_BUF_THR_STS.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ain_buf_thr_sts_test(int fd)
{

	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_AIN_BUF_THR_STS");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


