// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/ain_buf_overflow.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	// There are no persistent bits to test with this service.
	return(0);
}




//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		{				// Enable Rate-A Generator
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_RAGR,
			/* mask		*/	0x10000,
			/* value	*/	0x00000
		},
		{				// ADC source = Rate-A Generator.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x08
		},
		{				// Disable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x00
		},
		{				// Wait to see if we get any data.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	2,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that we don't have an overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x20000,
			/* value	*/	0x00000
		},
		{				// Verify that IGNORE changes nothing.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_BUF_OVERFLOW,
			/* arg		*/	AI32SSC_AIN_BUF_OVERFLOW_IGNORE,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x20000,
			/* value	*/	0x00000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		{				// Enable Rate-A Generator
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_RAGR,
			/* mask		*/	0x10000,
			/* value	*/	0x00000
		},
		{				// ADC source = Rate-A Generator.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x08
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{				// Wait to see if we get any data.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	2,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that we do have an overflow.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x20000,
			/* value	*/	0x20000
		},
		{				// Verify that IGNORE changes nothing.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_BUF_OVERFLOW,
			/* arg		*/	AI32SSC_AIN_BUF_OVERFLOW_IGNORE,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x20000,
			/* value	*/	0x20000
		},

		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_3[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_ADC_ENABLE,
			/* arg		*/	AI32SSC_ADC_ENABLE_NO,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait a moment.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Verify that CLEAR removes the status.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_AIN_BUF_OVERFLOW,
			/* arg		*/	AI32SSC_AIN_BUF_OVERFLOW_CLEAR,
			/* reg		*/	AI32SSC_GSC_BCTLR,
			/* mask		*/	0x20000,
			/* value	*/	0x00000
		},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	ret;
	s32	sts		= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= service_ioctl_set_reg_list(fd, list_1);

	if (errs == 0)
	{
		// Verify that the status is NO overflow.
		sts	= -1;
		ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_AIN_BUF_OVERFLOW, &sts);
		errs	+= ret ? 1 : 0;

		if (ret)
		{
			errs++;
		}
		else if (sts != AI32SSC_AIN_BUF_OVERFLOW_NO)
		{
			errs++;
			printf(	"FAIL <---  (%d. overflow occurred but unexpected)\n",
					__LINE__);
		}
	}

	errs	+= service_ioctl_set_reg_list(fd, list_2);

	if (errs == 0)
	{
		// Verify that the status IS an overflow.
		sts	= -1;
		ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_AIN_BUF_OVERFLOW, &sts);
		errs	+= ret ? 1 : 0;

		if (ret)
		{
			errs++;
		}
		else if (sts != AI32SSC_AIN_BUF_OVERFLOW_YES)
		{
			errs++;
			printf(	"FAIL <---  (%d. overflow expected but did not occur)\n",
					__LINE__);
		}
	}

	errs	+= service_ioctl_set_reg_list(fd, list_3);

	if (errs == 0)
	{
		// Verify that the status is NO overflow.
		sts		= -1;
		ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_AIN_BUF_OVERFLOW, &sts);
		errs	+= ret ? 1 : 0;

		if (ret)
		{
			errs++;
		}
		else if (sts != AI32SSC_AIN_BUF_OVERFLOW_NO)
		{
			errs++;
			printf(	"FAIL <---  (%d. overflow occurred but unexpected)\n",
					__LINE__);
		}
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	ain_buf_overflow_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_AIN_BUF_OVERFLOW.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ain_buf_overflow_test(int fd)
{
	int	errs		= 0;

	gsc_label("AI32SSC_IOCTL_AIN_BUF_OVERFLOW");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


