// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/ain_buf_level.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	// There are no persistent bits to test with this service.
	return(0);
}




//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list[]	=
	{
		// Put some data in the FIFO: unpacked, 16 samples, fifo size = 8

		{				// Scan channels 0-7
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x7,
			/* value	*/	0x3
		},
		{				// ADC source = BCR Control Bit
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x18
		},
		{				// Enable ADC operation.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait for possible data reception.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Perform an Input Sync operation.
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_INPUT_SYNC,
			/* arg		*/	0,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait for possible data reception.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},

		{ SERVICE_END_LIST }
	};

	int			errs	= 0;
	int			i;
	s32			lvl;
	gsc_reg_t	reg;
	int			ret;

	errs	+= ai32ssc_initialize(fd, -1, 0);
	errs	+= service_ioctl_set_reg_list(fd, list);

	// We're only testing the level accuracy from 16 samples to zero.

	for (i = 16; (errs == 0) && (i >= 0); i--)
	{
		ret	= ai32ssc_ioctl(fd, AI32SSC_IOCTL_AIN_BUF_LEVEL, &lvl);

		if (ret)
		{
			errs++;
			break;
		}
		else if (lvl != i)
		{
			errs++;
			printf("FAIL <---  (expected %d, got %ld)\n", i, (long) lvl);
			break;
		}

		reg.reg	= AI32SSC_GSC_IBDR;
		ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_REG_READ, &reg);

		if (ret)
		{
			errs++;
			break;
		}
	}

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	ain_buf_level_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_AIN_BUF_LEVEL.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ain_buf_level_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_AIN_BUF_LEVEL");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


