// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/sbtest/adc_enable.c $
// $Rev: 51366 $
// $Date: 2022-07-12 16:42:59 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_ADC_ENABLE,
			/* arg		*/	AI32SSC_ADC_ENABLE_YES,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x20
		},
		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_ADC_ENABLE,
			/* arg		*/	AI32SSC_ADC_ENABLE_NO,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x20,
			/* value	*/	0x00
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_reg_get_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list[]	=
	{
		{				// Set the threshold very low.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_IBCR,
			/* mask		*/	0x3FFFF,
			/* value	*/	0x0000F
		},
		{				// Enable Rate-A Generator
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_RAGR,
			/* mask		*/	0x10000,
			/* value	*/	0x00000
		},
		{				// ADC source = Rate-A Generator.
			/* service	*/	SERVICE_REG_MOD,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_SSCR,
			/* mask		*/	0x18,
			/* value	*/	0x08
		},

		// Verify that DISABLE inhibits data collection.

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_ADC_ENABLE,
			/* arg		*/	AI32SSC_ADC_ENABLE_NO,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait a moment to see if we get any data.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Verify that we got no data.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_IBCR,
			/* mask		*/	0x80000,
			/* value	*/	0x00000
		},

		// Verify that ENABLE permits data collection.

		{
			/* service	*/	SERVICE_NORMAL,
			/* cmd		*/	AI32SSC_IOCTL_ADC_ENABLE,
			/* arg		*/	AI32SSC_ADC_ENABLE_YES,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{				// Wait a moment to see if we get any data.
			/* service	*/	SERVICE_SLEEP,
			/* cmd		*/	0,
			/* arg		*/	1,
			/* reg		*/	-1,
			/* mask		*/	0,
			/* value	*/	0
		},
		{					// Verify that we got some data.
			/* service	*/	SERVICE_REG_TEST,
			/* cmd		*/	0,
			/* arg		*/	0,
			/* reg		*/	AI32SSC_GSC_IBCR,
			/* mask		*/	0x80000,
			/* value	*/	0x80000
		},

		{ SERVICE_END_LIST }
	};

	int errs	= 0;

	errs	+= ai32ssc_initialize(fd, -1, 0);

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= ai32ssc_initialize(fd, -1, 0);
	return(errs);
}




/******************************************************************************
*
*	Function:	adc_enable_test
*
*	Purpose:
*
*		Perform a test of the IOCTL service AI32SSC_IOCTL_ADC_ENABLE.
*
*	Arguments:
*
*		fd		The handle for the device to access.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int adc_enable_test(int fd)
{
	int	errs	= 0;

	gsc_label("AI32SSC_IOCTL_ADC_ENABLE");
	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	return(errs);
}


