// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/rxrate/perform.c $
// $Rev: 54765 $
// $Date: 2024-07-01 17:08:07 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M	(1024L * 1024L)



// variables ******************************************************************

static u8	_data[_1M];



//*****************************************************************************
static int _configuration(const args_t* args)
{
	int	errs	= 0;

	gsc_label("Configuration");
	errs	+= ai32ssc_config_ai		(args->fd, -1, 0, args->fsamp);
	printf("%s\n", errs ? "FAIL <---" : "PASS");

	errs	+= ai32ssc_rx_io_mode		(args->fd, -1, 1, args->io_mode, NULL);
	errs	+= ai32ssc_rx_io_overflow	(args->fd, -1, 1, AI32SSC_IO_OVERFLOW_IGNORE, NULL);
	errs	+= ai32ssc_rx_io_underflow	(args->fd, -1, 1, AI32SSC_IO_UNDERFLOW_IGNORE, NULL);
	errs	+= ai32ssc_fsamp_report_all	(args->fd, -1, 1, NULL);
	errs	+= ai32ssc_ain_buf_clear	(args->fd, -1, 1, 0);

	return(errs);
}



//*****************************************************************************
static int _rate_test(const args_t* args, long get)
{
	struct timeval	begin;
	int				errs	= 0;
	long			got;
	long long		limit	= (long long) args->rx_mb * 1000000L;
	struct timeval	minimum;
	struct timeval	now;
	long long		sps;
	long long		total	= 0;
	long			us;

	gsc_label("Reading");

	gettimeofday(&begin, NULL);
	minimum.tv_sec	= begin.tv_sec + args->seconds;
	minimum.tv_usec	= begin.tv_usec;

	for (;;)
	{
		got	= ai32ssc_read(args->fd, _data, get);

		if (got < 0)
		{
			errs++;
			printf("FAIL <--- (read");
			printf(", total so far %lld", total);
			printf(", requested %ld bytes", (long) get);
			printf(", error %ld)\n", got);
			break;
		}

		gettimeofday(&now, NULL);
		total	+= got;

		if (total < limit)
			continue;

		if (now.tv_sec < minimum.tv_sec)
			continue;

		if ((now.tv_sec == minimum.tv_sec) && (now.tv_usec < minimum.tv_usec))
			continue;

		us	= (now.tv_sec - begin.tv_sec) * 1000000L
			+ (now.tv_usec - begin.tv_usec);
		sps	= (total * 10000000L / 4 / us + 5) / 10;

		printf(	"PASS  (");
		gsc_label_long_comma(total / 4);
		printf(" Samples, %ld.%06ld Seconds, ", us / 1000000, us % 1000000);
		gsc_label_long_comma(sps);
		printf(" S/S)\n");
		break;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	long	get		= sizeof(_data);

	errs	+= _configuration(args);

	gsc_label ("Read Rate");
	printf("(%d second minimum, %ld MB minimum)\n", args->seconds, (long) args->rx_mb);
	gsc_label_level_inc();

	errs	+= _rate_test(args, get);

	errs	+= ai32ssc_ain_buf_overflow	(args->fd, -1, 1, -1, NULL);
	errs	+= ai32ssc_ain_buf_underflow(args->fd, -1, 1, -1, NULL);

	gsc_label_level_dec();
	return(errs);
}



