// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/linux/os_utils.h $
// $Rev: 46871 $
// $Date: 2020-02-24 13:10:43 -0600 (Mon, 24 Feb 2020) $

// Linux: Utility: header file

#ifndef	__OS_UTILS_H__
#define	__OS_UTILS_H__

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <semaphore.h>
#include <termios.h>
#include <time.h>
#include <unistd.h>
#include <asm/types.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/utsname.h>

#include "os_common.h"



// #define ********************************************************************

#define	MMAP_IS_SUPPORTED				1	// defined only for Linux

#define	os_time_get_us(t)				gettimeofday((t), NULL)

#if !defined(BITS_PER_LONG)
	#if (ULONG_MAX == 4294967295UL)				// 0xFFFFFFFF
		#define	BITS_PER_LONG	32
	#elif (ULONG_MAX == 18446744073709551615UL)	// 0xFFFFFFFFFFFFFFFF
		#define	BITS_PER_LONG	64
	#else
		#error "UNABLE TO DEFINE BITS_PER_LONG."
	#endif
#endif

#if (BITS_PER_LONG == 32)

	#define	I2VP		void*				// cast a 32-bit int to a 32-bit void*
	#define	ULL2VP		void*) (long		// cast a 64-bit ULL to a 32-bit void*
	#define	VP2I		int					// cast a 32-bit void* to a 32-bit int
	#define	VP2U8		char) (int			// cast a 32-bit void* to an 8-bit unsigned char
	#define	VP2ULL		long long) (long	// cast a 32-bit void* to a 64-bit ULL

#elif (BITS_PER_LONG == 64)

	#define	I2VP		void*) (long		// cast a 32-bit int to a 64-bit void*
	#define	ULL2VP		void*				// cast a 64-bit ULL to a 64-bit void*
	#define	VP2I		int) (long			// cast a 64-bit void* to a 32-bit int
	#define	VP2U8		char) (long			// cast a 64-bit void* to an 8-bit unsigned char
	#define	VP2ULL		long long			// cast a 64-bit void* to a 64-bit ULL

#else
	#error "BITS_PER_LONG IS NOT DEFINED."
#endif



// data types *****************************************************************

typedef struct timeval	os_time_us_t;
typedef struct timespec	os_time_ns_t;

typedef	struct
{
	void*		key;	// struct is valid only if key == & of struct
	sem_t		sem;
} os_sem_t;

typedef struct
{
	pthread_t	thread;
	char		name[64];
} os_thread_t;



// prototypes *****************************************************************

int		os_count_boards(	int		verbose,
							int*	qty,
							int		(*dev_open)(int device, int share, int* fd),
							int		(*dev_read)(int fd, void* dst, size_t size),
							int		(*dev_close)(int fd));

int		os_id_driver(	int	(*dev_open)(int index, int share, int* fd),
						int	(*dev_read)(int fd, void* dst, size_t size),
						int	(*dev_close)(int fd));
void	os_id_host(void);

void	os_kbd_close(void);
void	os_kbd_open(void);
int		os_kbd_hit(void);
int		os_kbd_read(void);

int		os_sem_create(os_sem_t* sem);
int		os_sem_create_qty(os_sem_t* sem, int cap, int put);
int		os_sem_destroy(os_sem_t* sem);
int		os_sem_lock(os_sem_t* sem);
int		os_sem_unlock(os_sem_t* sem);

void	os_sleep_ms(int ms);

int		os_thread_create(os_thread_t* thread, const char* name, int (*func)(void* arg), void* arg);
int		os_thread_destroy(os_thread_t* thread);
size_t	os_time_delta_ms(void);
int		os_time_get_ns(os_time_ns_t* tns);



#endif
