// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/include/16ai32ssc_utils.h $
// $Rev: 54753 $
// $Date: 2024-07-01 09:38:36 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Utilities: header file

#ifndef	__16AI32SSC_UTILS_H__
#define	__16AI32SSC_UTILS_H__

#include "16ai32ssc_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	ai32ssc_close_util			(int fd, int index, int verbose);
int ai32ssc_init_util			(int verbose);
int ai32ssc_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	ai32ssc_open_util			(int device, int share, int index, int verbose, int* fd);
int	ai32ssc_read_util			(int fd, int index, int verbose, void* dst, size_t bytes, size_t* got);

// IOCTL utility services

int	ai32ssc_adc_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_ADC_CLK_SRC
int	ai32ssc_adc_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_ADC_ENABLE
int	ai32ssc_ain_buf_clear		(int fd, int index, int verbose, int at_boundary);				// AI32SSC_IOCTL_AIN_BUF_CLEAR
int	ai32ssc_ain_buf_level		(int fd, int index, int verbose, s32* get);						// AI32SSC_IOCTL_AIN_BUF_LEVEL
int	ai32ssc_ain_buf_overflow	(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AIN_BUF_OVERFLOW
int	ai32ssc_ain_buf_thr_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AIN_BUF_THR_LVL
int	ai32ssc_ain_buf_thr_sts		(int fd, int index, int verbose, s32* get);						// AI32SSC_IOCTL_AIN_BUF_THR_STS
int	ai32ssc_ain_buf_underflow	(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AIN_BUF_UNDERFLOW
int	ai32ssc_ain_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AIN_MODE
int	ai32ssc_ain_range			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AIN_RANGE
int	ai32ssc_autocal				(int fd, int index, int verbose);								// AI32SSC_IOCTL_AUTOCAL
int	ai32ssc_aux_clk_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AUX_CLK_MODE
int	ai32ssc_aux_in_pol			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AUX_IN_POL
int	ai32ssc_aux_noise			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AUX_NOISE
int	ai32ssc_aux_out_pol			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AUX_OUT_POL
int	ai32ssc_aux_sync_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_AUX_SYNC_MODE
int	ai32ssc_burst_busy			(int fd, int index, int verbose, s32* get);						// AI32SSC_IOCTL_BURST_BUSY
int	ai32ssc_burst_size			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_BURST_SIZE
int	ai32ssc_burst_sync			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_BURST_SYNC
int	ai32ssc_chan_active			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_CHAN_ACTIVE
int	ai32ssc_chan_first			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_CHAN_FIRST
int	ai32ssc_chan_last			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_CHAN_LAST
int	ai32ssc_chan_single			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_CHAN_SINGLE
int	ai32ssc_data_format			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_DATA_FORMAT
int	ai32ssc_data_packing		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_DATA_PACKING
int	ai32ssc_initialize			(int fd, int index, int verbose);								// AI32SSC_IOCTL_INITIALIZE
int	ai32ssc_input_sync			(int fd, int index, int verbose);								// AI32SSC_IOCTL_INPUT_SYNC
int	ai32ssc_io_inv				(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_IO_INV
int	ai32ssc_irq0_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_IRQ0_SEL
int	ai32ssc_irq1_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_IRQ1_SEL
int	ai32ssc_ll_doh				(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_LL_DOH
int	ai32ssc_ll_read				(int fd, int index, int verbose, ai32ssc_ll_data_t* get);		// AI32SSC_IOCTL_LL_READ
int	ai32ssc_query				(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_QUERY
int	ai32ssc_rag_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RAG_ENABLE
int	ai32ssc_rag_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RAG_NRATE
int	ai32ssc_rbg_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RBG_CLK_SRC
int	ai32ssc_rbg_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RBG_ENABLE
int	ai32ssc_rbg_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RBG_NRATE
int	ai32ssc_rbg_sync_output		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RBG_SYNC_OUTPUT
int	ai32ssc_reg_mod				(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// AI32SSC_IOCTL_REG_MOD
int	ai32ssc_reg_read			(int fd, int index, int verbose, u32 reg, u32* value);			// AI32SSC_IOCTL_REG_READ
int	ai32ssc_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// AI32SSC_IOCTL_REG_WRITE
int	ai32ssc_rx_io_abort			(int fd, int index, int verbose, s32* get);						// AI32SSC_IOCTL_RX_IO_ABORT
int	ai32ssc_rx_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RX_IO_MODE
int	ai32ssc_rx_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RX_IO_OVERFLOW
int	ai32ssc_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RX_IO_TIMEOUT
int	ai32ssc_rx_io_underflow		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_RX_IO_UNDERFLOW
int	ai32ssc_scan_marker			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_SCAN_MARKER
int	ai32ssc_scan_marker_val		(int fd, int index, int verbose, u32 set, u32* get);			// AI32SSC_IOCTL_SCAN_MARKER_VAL
int	ai32ssc_tt_adc_clk_src		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_ADC_CLK_SRC
int	ai32ssc_tt_adc_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_ADC_ENABLE
int	ai32ssc_tt_chan_mask		(int fd, int index, int verbose, u32 set, u32* get);			// AI32SSC_IOCTL_TT_CHAN_MASK
int	ai32ssc_tt_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_ENABLE
int	ai32ssc_tt_log_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_LOG_MODE
int ai32ssc_tt_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_NRATE
int	ai32ssc_tt_ref_clk_src		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_REF_CLK_SRC
int	ai32ssc_tt_ref_val_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_REF_VAL_MODE
int	ai32ssc_tt_ref_xx			(int fd, int index, int verbose, int chan, s32 set, s32* get);	// AI32SSC_IOCTL_TT_REF_XX
int	ai32ssc_tt_reset			(int fd, int index, int verbose);								// AI32SSC_IOCTL_TT_RESET
int	ai32ssc_tt_reset_ext		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_RESET_EXT
int	ai32ssc_tt_tagging			(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_TAGGING
int	ai32ssc_tt_thr_xx			(int fd, int index, int verbose, int chan, s32 set, s32* get);	// AI32SSC_IOCTL_TT_THR_XX
int	ai32ssc_tt_trig_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AI32SSC_IOCTL_TT_TRIG_MODE
int	ai32ssc_wait_cancel			(int fd, int index, int verbose, gsc_wait_t* wait);				// AI32SSC_IOCTL_WAIT_CANCEL
int	ai32ssc_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// AI32SSC_IOCTL_WAIT_EVENT
int	ai32ssc_wait_status			(int fd, int index, int verbose, gsc_wait_t* wait);				// AI32SSC_IOCTL_WAIT_STATUS

// Auxiliary utility services

int	ai32ssc_config_ai			(int fd, int index, int verbose, s32 fsamp);
int	ai32ssc_config_aux			(int fd, int index, int verbose);
int	ai32ssc_config_tt			(int fd, int index, int verbose, s32 nrate_a, s32 nrate_tt);
int	ai32ssc_fsamp_compute		(int fd, int index, int verbose, s32 fsamp, s32* src, s32* src_b, s32* nrate_a, s32* nrate_b, s32* enable_a, s32* enable_b, double* rate);
int	ai32ssc_fsamp_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int	ai32ssc_fsamp_report_all	(int fd, int index, int verbose, s32* fsamp);
int	ai32ssc_id_device			(int fd, int index, int verbose);

int	ai32ssc_count_boards		(int verbose, s32* get);
int	ai32ssc_reg_list			(int fd, int detail);

const gsc_reg_def_t*			ai32ssc_reg_get_def_id		(u32 reg);
const gsc_reg_def_t*			ai32ssc_reg_get_def_index	(int index);
const char*						ai32ssc_reg_get_desc		(u32 reg);
const char*						ai32ssc_reg_get_name		(u32 reg);



#endif
