// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/driver/16ai32ssc.h $
// $Rev: 54770 $
// $Date: 2024-07-01 17:22:23 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Device Driver: header file

#ifndef	__16AI32SSC_H__
#define	__16AI32SSC_H__

#include "gsc_common.h"
#include "gsc_pci9056.h"



// macros *********************************************************************

#define	AI32SSC_BASE_NAME					"16ai32ssc"

// IOCTL command codes
#define	AI32SSC_IOCTL_REG_READ				OS_IOCTL_RW(  0, 12, gsc_reg_t)
#define	AI32SSC_IOCTL_REG_WRITE				OS_IOCTL_W (  1, 12, gsc_reg_t)
#define	AI32SSC_IOCTL_REG_MOD				OS_IOCTL_W (  2, 12, gsc_reg_t)
#define	AI32SSC_IOCTL_QUERY					OS_IOCTL_RW(  3,  4, s32)
#define	AI32SSC_IOCTL_INITIALIZE			OS_IOCTL   (  4)
#define	AI32SSC_IOCTL_AUTOCAL				OS_IOCTL   (  5)
#define	AI32SSC_IOCTL_RX_IO_MODE			OS_IOCTL_RW(  6,  4, s32)
#define	AI32SSC_IOCTL_RX_IO_OVERFLOW		OS_IOCTL_RW(  7,  4, s32)
#define	AI32SSC_IOCTL_RX_IO_TIMEOUT			OS_IOCTL_RW(  8,  4, s32)
#define	AI32SSC_IOCTL_RX_IO_UNDERFLOW		OS_IOCTL_RW(  9,  4, s32)
#define	AI32SSC_IOCTL_ADC_CLK_SRC			OS_IOCTL_RW( 10,  4, s32)
#define	AI32SSC_IOCTL_ADC_ENABLE			OS_IOCTL_RW( 11,  4, s32)
#define	AI32SSC_IOCTL_AIN_BUF_CLEAR			OS_IOCTL   ( 12)
#define	AI32SSC_IOCTL_AIN_BUF_LEVEL			OS_IOCTL_R ( 13,  4, s32)
#define	AI32SSC_IOCTL_AIN_BUF_OVERFLOW		OS_IOCTL_RW( 14,  4, s32)
#define	AI32SSC_IOCTL_AIN_BUF_THR_LVL		OS_IOCTL_RW( 15,  4, s32)
#define	AI32SSC_IOCTL_AIN_BUF_THR_STS		OS_IOCTL_R ( 16,  4, s32)
#define	AI32SSC_IOCTL_AIN_BUF_UNDERFLOW		OS_IOCTL_RW( 17,  4, s32)
#define	AI32SSC_IOCTL_AIN_MODE				OS_IOCTL_RW( 18,  4, s32)
#define	AI32SSC_IOCTL_AIN_RANGE				OS_IOCTL_RW( 19,  4, s32)
#define	AI32SSC_IOCTL_BURST_BUSY			OS_IOCTL_R ( 20,  4, s32)
#define	AI32SSC_IOCTL_BURST_SIZE			OS_IOCTL_RW( 21,  4, s32)
#define	AI32SSC_IOCTL_BURST_SYNC			OS_IOCTL_RW( 22,  4, s32)
#define	AI32SSC_IOCTL_CHAN_ACTIVE			OS_IOCTL_RW( 23,  4, s32)
#define	AI32SSC_IOCTL_CHAN_FIRST			OS_IOCTL_RW( 24,  4, s32)
#define	AI32SSC_IOCTL_CHAN_LAST				OS_IOCTL_RW( 25,  4, s32)
#define	AI32SSC_IOCTL_CHAN_SINGLE			OS_IOCTL_RW( 26,  4, s32)
#define	AI32SSC_IOCTL_DATA_FORMAT			OS_IOCTL_RW( 27,  4, s32)
#define	AI32SSC_IOCTL_DATA_PACKING			OS_IOCTL_RW( 28,  4, s32)
#define	AI32SSC_IOCTL_INPUT_SYNC			OS_IOCTL   ( 29)
#define	AI32SSC_IOCTL_IO_INV				OS_IOCTL_RW( 30,  4, s32)
#define	AI32SSC_IOCTL_IRQ0_SEL				OS_IOCTL_RW( 31,  4, s32)
#define	AI32SSC_IOCTL_IRQ1_SEL				OS_IOCTL_RW( 32,  4, s32)
#define	AI32SSC_IOCTL_RAG_ENABLE			OS_IOCTL_RW( 33,  4, s32)
#define	AI32SSC_IOCTL_RAG_NRATE				OS_IOCTL_RW( 34,  4, s32)
#define	AI32SSC_IOCTL_RBG_CLK_SRC			OS_IOCTL_RW( 35,  4, s32)
#define	AI32SSC_IOCTL_RBG_ENABLE			OS_IOCTL_RW( 36,  4, s32)
#define	AI32SSC_IOCTL_RBG_NRATE				OS_IOCTL_RW( 37,  4, s32)
#define	AI32SSC_IOCTL_SCAN_MARKER			OS_IOCTL_RW( 38,  4, s32)
#define	AI32SSC_IOCTL_AUX_CLK_MODE			OS_IOCTL_RW( 39,  4, s32)
#define	AI32SSC_IOCTL_AUX_IN_POL			OS_IOCTL_RW( 40,  4, s32)
#define	AI32SSC_IOCTL_AUX_NOISE				OS_IOCTL_RW( 41,  4, s32)
#define	AI32SSC_IOCTL_AUX_OUT_POL			OS_IOCTL_RW( 42,  4, s32)
#define	AI32SSC_IOCTL_AUX_SYNC_MODE			OS_IOCTL_RW( 43,  4, s32)
#define	AI32SSC_IOCTL_TT_ADC_CLK_SRC		OS_IOCTL_RW( 44,  4, s32)
#define	AI32SSC_IOCTL_TT_ADC_ENABLE			OS_IOCTL_RW( 45,  4, s32)
#define	AI32SSC_IOCTL_TT_CHAN_MASK			OS_IOCTL_W ( 46,  4, u32)
#define	AI32SSC_IOCTL_TT_ENABLE				OS_IOCTL_RW( 47,  4, s32)
#define	AI32SSC_IOCTL_TT_LOG_MODE			OS_IOCTL_RW( 48,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_CLK_SRC		OS_IOCTL_RW( 49,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_VAL_MODE		OS_IOCTL_RW( 50,  4, s32)
#define	AI32SSC_IOCTL_TT_RESET				OS_IOCTL   ( 51)
#define	AI32SSC_IOCTL_TT_RESET_EXT			OS_IOCTL_RW( 52,  4, s32)
#define	AI32SSC_IOCTL_TT_TAGGING			OS_IOCTL_RW( 53,  4, s32)
#define	AI32SSC_IOCTL_TT_TRIG_MODE			OS_IOCTL_RW( 54,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_00				OS_IOCTL_RW( 55,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_01				OS_IOCTL_RW( 56,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_02				OS_IOCTL_RW( 57,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_03				OS_IOCTL_RW( 58,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_04				OS_IOCTL_RW( 59,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_05				OS_IOCTL_RW( 60,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_06				OS_IOCTL_RW( 61,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_07				OS_IOCTL_RW( 62,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_08				OS_IOCTL_RW( 63,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_09				OS_IOCTL_RW( 64,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_10				OS_IOCTL_RW( 65,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_11				OS_IOCTL_RW( 66,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_12				OS_IOCTL_RW( 67,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_13				OS_IOCTL_RW( 68,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_14				OS_IOCTL_RW( 69,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_15				OS_IOCTL_RW( 70,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_16				OS_IOCTL_RW( 71,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_17				OS_IOCTL_RW( 72,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_18				OS_IOCTL_RW( 73,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_19				OS_IOCTL_RW( 74,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_20				OS_IOCTL_RW( 75,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_21				OS_IOCTL_RW( 76,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_22				OS_IOCTL_RW( 77,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_23				OS_IOCTL_RW( 78,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_24				OS_IOCTL_RW( 79,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_25				OS_IOCTL_RW( 80,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_26				OS_IOCTL_RW( 81,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_27				OS_IOCTL_RW( 82,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_28				OS_IOCTL_RW( 83,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_29				OS_IOCTL_RW( 84,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_30				OS_IOCTL_RW( 85,  4, s32)
#define	AI32SSC_IOCTL_TT_REF_31				OS_IOCTL_RW( 86,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_00				OS_IOCTL_RW( 87,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_01				OS_IOCTL_RW( 88,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_02				OS_IOCTL_RW( 89,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_03				OS_IOCTL_RW( 90,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_04				OS_IOCTL_RW( 91,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_05				OS_IOCTL_RW( 92,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_06				OS_IOCTL_RW( 93,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_07				OS_IOCTL_RW( 94,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_08				OS_IOCTL_RW( 95,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_09				OS_IOCTL_RW( 96,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_10				OS_IOCTL_RW( 97,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_11				OS_IOCTL_RW( 98,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_12				OS_IOCTL_RW( 99,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_13				OS_IOCTL_RW(100,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_14				OS_IOCTL_RW(101,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_15				OS_IOCTL_RW(102,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_16				OS_IOCTL_RW(103,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_17				OS_IOCTL_RW(104,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_18				OS_IOCTL_RW(105,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_19				OS_IOCTL_RW(106,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_20				OS_IOCTL_RW(107,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_21				OS_IOCTL_RW(108,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_22				OS_IOCTL_RW(109,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_23				OS_IOCTL_RW(110,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_24				OS_IOCTL_RW(111,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_25				OS_IOCTL_RW(112,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_26				OS_IOCTL_RW(113,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_27				OS_IOCTL_RW(114,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_28				OS_IOCTL_RW(115,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_29				OS_IOCTL_RW(116,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_30				OS_IOCTL_RW(117,  4, s32)
#define	AI32SSC_IOCTL_TT_THR_31				OS_IOCTL_RW(118,  4, s32)
#define	AI32SSC_IOCTL_TT_NRATE				OS_IOCTL_RW(119,  4, s32)
#define	AI32SSC_IOCTL_RX_IO_ABORT			OS_IOCTL_R (120,  4, s32)
#define	AI32SSC_IOCTL_WAIT_EVENT			OS_IOCTL_RW(121, 28, gsc_wait_t)
#define	AI32SSC_IOCTL_WAIT_CANCEL			OS_IOCTL_RW(122, 28, gsc_wait_t)
#define	AI32SSC_IOCTL_WAIT_STATUS			OS_IOCTL_RW(123, 28, gsc_wait_t)
#define	AI32SSC_IOCTL_SCAN_MARKER_VAL		OS_IOCTL_RW(124,  4, u32)
#define	AI32SSC_IOCTL_RBG_SYNC_OUTPUT		OS_IOCTL_RW(125,  4, s32)
#define	AI32SSC_IOCTL_LL_DOH				OS_IOCTL_R (126,  4, s32)
//		AI32SSC_IOCTL_LL_HOLD				Feature never incorporated into firmware
#define	AI32SSC_IOCTL_LL_READ				OS_IOCTL_RW(128,132, ai32ssc_ll_data_t)
//		AI32SSC_IOCTL_LL_RELEASE			Feature never incorporated into firmware
#define	AI32SSC_IOCTL_RX_IO_PIO_THRESH		OS_IOCTL_RW(130,  4, s32)
#define	AI32SSC_IOCTL_RX_IO_BMDMA_THRESH	OS_IOCTL_RW(131,  4, s32)



//*****************************************************************************
// AI32SSC_IOCTL_REG_READ
// AI32SSC_IOCTL_REG_WRITE
// AI32SSC_IOCTL_REG_MOD
//
#define	AI32SSC_REG_ENCODE(s,o)				GSC_REG_ENCODE(GSC_REG_TYPE_BAR2,(s),(o))
// Parameter:	gsc_reg_t*
#define	AI32SSC_GSC_BCTLR					AI32SSC_REG_ENCODE(4,0x00)// Board Control Register
#define	AI32SSC_GSC_ICR						AI32SSC_REG_ENCODE(4,0x04)// Interrupt Control Register
#define	AI32SSC_GSC_IBDR					AI32SSC_REG_ENCODE(4,0x08)// Input Buffer Data Register
#define	AI32SSC_GSC_IBCR					AI32SSC_REG_ENCODE(4,0x0C)// Input Buffer Control Register
#define	AI32SSC_GSC_RAGR					AI32SSC_REG_ENCODE(4,0x10)// Rate-A Generator Register
#define	AI32SSC_GSC_RBGR					AI32SSC_REG_ENCODE(4,0x14)// Rate-B Generator Register
#define	AI32SSC_GSC_BUFSR					AI32SSC_REG_ENCODE(4,0x18)// Buffer Size Register
#define	AI32SSC_GSC_BSIZR					AI32SSC_REG_ENCODE(4,0x1C)// Burst Size Register
#define	AI32SSC_GSC_SSCR					AI32SSC_REG_ENCODE(4,0x20)// Scan & Sync Control Register
#define	AI32SSC_GSC_ACAR					AI32SSC_REG_ENCODE(4,0x24)// Active Channel Assignment Register
#define	AI32SSC_GSC_BCFGR					AI32SSC_REG_ENCODE(4,0x28)// Board Configuration Register
#define	AI32SSC_GSC_AVR						AI32SSC_REG_ENCODE(4,0x2C)// Auto Cal Values Register
#define	AI32SSC_GSC_AWRR					AI32SSC_REG_ENCODE(4,0x30)// Auxiliary R/W Register
#define	AI32SSC_GSC_ASIOCR					AI32SSC_REG_ENCODE(4,0x34)// Auxiliary Sync I/O Control Register
#define	AI32SSC_GSC_SMUWR					AI32SSC_REG_ENCODE(4,0x38)// Scan Marker Upper Word Register
#define	AI32SSC_GSC_SMLWR					AI32SSC_REG_ENCODE(4,0x3C)// Scan Marker Lower Word Register
//		AI32SSC_GSC_LLCR					Never added to firmware	  // Low Latency Control Register

// These are the Time Tag registers
#define	AI32SSC_GSC_TTCR					AI32SSC_REG_ENCODE(4,0x50)// Time Tag Cinfiguration Register
#define	AI32SSC_GSC_TTACMR					AI32SSC_REG_ENCODE(4,0x54)// Time Tag Active Channel Mask Register
#define	AI32SSC_GSC_TTCLR					AI32SSC_REG_ENCODE(4,0x58)// Time Tag Counter Lower Register
#define	AI32SSC_GSC_TTCUR					AI32SSC_REG_ENCODE(4,0x5C)// Time Tag Counter Upper Register
#define	AI32SSC_GSC_TTRDR					AI32SSC_REG_ENCODE(4,0x60)// Time Tag Rate Divider Register
#define	AI32SSC_GSC_TTBSR					AI32SSC_REG_ENCODE(4,0x64)// Time Tag Burst Size Register

#define	AI32SSC_GSC_TTC00TRR				AI32SSC_REG_ENCODE(4,0x80)// Time Tag Channel 00 Threshold/Reference Register
#define	AI32SSC_GSC_TTC01TRR				AI32SSC_REG_ENCODE(4,0x84)// Time Tag Channel 01 Threshold/Reference Register
#define	AI32SSC_GSC_TTC02TRR				AI32SSC_REG_ENCODE(4,0x88)// Time Tag Channel 02 Threshold/Reference Register
#define	AI32SSC_GSC_TTC03TRR				AI32SSC_REG_ENCODE(4,0x8C)// Time Tag Channel 03 Threshold/Reference Register
#define	AI32SSC_GSC_TTC04TRR				AI32SSC_REG_ENCODE(4,0x90)// Time Tag Channel 04 Threshold/Reference Register
#define	AI32SSC_GSC_TTC05TRR				AI32SSC_REG_ENCODE(4,0x94)// Time Tag Channel 05 Threshold/Reference Register
#define	AI32SSC_GSC_TTC06TRR				AI32SSC_REG_ENCODE(4,0x98)// Time Tag Channel 06 Threshold/Reference Register
#define	AI32SSC_GSC_TTC07TRR				AI32SSC_REG_ENCODE(4,0x9C)// Time Tag Channel 07 Threshold/Reference Register
#define	AI32SSC_GSC_TTC08TRR				AI32SSC_REG_ENCODE(4,0xA0)// Time Tag Channel 08 Threshold/Reference Register
#define	AI32SSC_GSC_TTC09TRR				AI32SSC_REG_ENCODE(4,0xA4)// Time Tag Channel 09 Threshold/Reference Register

#define	AI32SSC_GSC_TTC10TRR				AI32SSC_REG_ENCODE(4,0xA8)// Time Tag Channel 10 Threshold/Reference Register
#define	AI32SSC_GSC_TTC11TRR				AI32SSC_REG_ENCODE(4,0xAC)// Time Tag Channel 11 Threshold/Reference Register
#define	AI32SSC_GSC_TTC12TRR				AI32SSC_REG_ENCODE(4,0xB0)// Time Tag Channel 12 Threshold/Reference Register
#define	AI32SSC_GSC_TTC13TRR				AI32SSC_REG_ENCODE(4,0xB4)// Time Tag Channel 13 Threshold/Reference Register
#define	AI32SSC_GSC_TTC14TRR				AI32SSC_REG_ENCODE(4,0xB8)// Time Tag Channel 14 Threshold/Reference Register
#define	AI32SSC_GSC_TTC15TRR				AI32SSC_REG_ENCODE(4,0xBC)// Time Tag Channel 15 Threshold/Reference Register
#define	AI32SSC_GSC_TTC16TRR				AI32SSC_REG_ENCODE(4,0xC0)// Time Tag Channel 16 Threshold/Reference Register
#define	AI32SSC_GSC_TTC17TRR				AI32SSC_REG_ENCODE(4,0xC4)// Time Tag Channel 17 Threshold/Reference Register
#define	AI32SSC_GSC_TTC18TRR				AI32SSC_REG_ENCODE(4,0xC8)// Time Tag Channel 18 Threshold/Reference Register
#define	AI32SSC_GSC_TTC19TRR				AI32SSC_REG_ENCODE(4,0xCC)// Time Tag Channel 19 Threshold/Reference Register

#define	AI32SSC_GSC_TTC20TRR				AI32SSC_REG_ENCODE(4,0xD0)// Time Tag Channel 20 Threshold/Reference Register
#define	AI32SSC_GSC_TTC21TRR				AI32SSC_REG_ENCODE(4,0xD4)// Time Tag Channel 21 Threshold/Reference Register
#define	AI32SSC_GSC_TTC22TRR				AI32SSC_REG_ENCODE(4,0xD8)// Time Tag Channel 22 Threshold/Reference Register
#define	AI32SSC_GSC_TTC23TRR				AI32SSC_REG_ENCODE(4,0xDC)// Time Tag Channel 23 Threshold/Reference Register
#define	AI32SSC_GSC_TTC24TRR				AI32SSC_REG_ENCODE(4,0xE0)// Time Tag Channel 24 Threshold/Reference Register
#define	AI32SSC_GSC_TTC25TRR				AI32SSC_REG_ENCODE(4,0xE4)// Time Tag Channel 25 Threshold/Reference Register
#define	AI32SSC_GSC_TTC26TRR				AI32SSC_REG_ENCODE(4,0xE8)// Time Tag Channel 26 Threshold/Reference Register
#define	AI32SSC_GSC_TTC27TRR				AI32SSC_REG_ENCODE(4,0xEC)// Time Tag Channel 27 Threshold/Reference Register
#define	AI32SSC_GSC_TTC28TRR				AI32SSC_REG_ENCODE(4,0xF0)// Time Tag Channel 28 Threshold/Reference Register
#define	AI32SSC_GSC_TTC29TRR				AI32SSC_REG_ENCODE(4,0xF4)// Time Tag Channel 29 Threshold/Reference Register

#define	AI32SSC_GSC_TTC30TRR				AI32SSC_REG_ENCODE(4,0xF8)// Time Tag Channel 30 Threshold/Reference Register
#define	AI32SSC_GSC_TTC31TRR				AI32SSC_REG_ENCODE(4,0xFC)// Time Tag Channel 31 Threshold/Reference Register

//*****************************************************************************
// AI32SSC_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	AI32SSC_QUERY_AUTOCAL_MS,		// Max autocalibrate period in ms.
	AI32SSC_QUERY_CHANNEL_MAX,		// Maximum number of channels supported.
	AI32SSC_QUERY_CHANNEL_QTY,		// The number of A/D channels.
	AI32SSC_QUERY_COUNT,			// How many query options are supported?
	AI32SSC_QUERY_DEVICE_TYPE,		// Value from gsc_dev_type_t
	AI32SSC_QUERY_FGEN_MAX,			// Rate Generator maximum output rate.
	AI32SSC_QUERY_FGEN_MIN,			// Rate Generator minimum output rate.
	AI32SSC_QUERY_FIFO_SIZE,		// FIFO depth in 32-bit samples
	AI32SSC_QUERY_FSAMP_MAX,		// The maximum sample rate per channel.
	AI32SSC_QUERY_FSAMP_MIN,		// The minimum sample rate per channel.
	AI32SSC_QUERY_INIT_MS,			// Max initialize period in ms.
	AI32SSC_QUERY_MASTER_CLOCK,		// Master clock frequency
	AI32SSC_QUERY_NRATE_MASK,		// Mask of valid Nrate bits.
	AI32SSC_QUERY_NRATE_MAX,		// Maximum rate generator Nrate value.
	AI32SSC_QUERY_NRATE_MIN,		// Maximum rate generator Nrate value.
	AI32SSC_QUERY_RATE_GEN_QTY,		// Number of Rate Generatorts.
	AI32SSC_QUERY_TIME_TAG,			// Is Time Tagging supported?
	AI32SSC_QUERY_RBG_SYNC_OUTPUT,	// Is Rate-B Generator SYNC Output supported?
	AI32SSC_QUERY_LOW_LATENCY,		// Is Low Latency supported?

	AI32SSC_IOCTL_QUERY_LAST
} ai32ssc_query_t;

#define	AI32SSC_IOCTL_QUERY_ERROR			(-1)

// Retained for backwards compatibility:
#define	AI32SSC_QUERY_AUTO_CAL_MS			AI32SSC_QUERY_AUTOCAL_MS

//*****************************************************************************
// AI32SSC_IOCTL_INITIALIZE					BCTLR D15
//
//	Parameter:	None

//*****************************************************************************
// AI32SSC_IOCTL_AUTOCAL					BCTLR D13
//
//	Parameter:	None

// Retained for backwards compatibility:
#define	AI32SSC_IOCTL_AUTO_CALIBRATE		AI32SSC_IOCTL_AUTOCAL

//*****************************************************************************
// AI32SSC_IOCTL_RX_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	AI32SSC_IO_MODE_DEFAULT				GSC_IO_MODE_PIO

//*****************************************************************************
// AI32SSC_IOCTL_RX_IO_OVERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_IO_OVERFLOW_DEFAULT			AI32SSC_IO_OVERFLOW_CHECK
#define	AI32SSC_IO_OVERFLOW_IGNORE			0
#define	AI32SSC_IO_OVERFLOW_CHECK			1

//*****************************************************************************
// AI32SSC_IOCTL_RX_IO_TIMEOUT (in seconds)
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	AI32SSC_IO_TIMEOUT_DEFAULT			10
#define	AI32SSC_IO_TIMEOUT_NO_SLEEP			0
#define	AI32SSC_IO_TIMEOUT_MIN				0
#define	AI32SSC_IO_TIMEOUT_MAX				GSC_IO_TIMEOUT_MAX
#define	AI32SSC_IO_TIMEOUT_INFINITE			GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// AI32SSC_IOCTL_RX_IO_UNDERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_IO_UNDERFLOW_DEFAULT		AI32SSC_IO_UNDERFLOW_CHECK
#define	AI32SSC_IO_UNDERFLOW_IGNORE			0
#define	AI32SSC_IO_UNDERFLOW_CHECK			1

//*****************************************************************************
// AI32SSC_IOCTL_ADC_CLK_SRC				SSCR D3-D4
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_ADC_CLK_SRC_EXT				0
#define	AI32SSC_ADC_CLK_SRC_RAG				1
#define	AI32SSC_ADC_CLK_SRC_RBG				2
#define	AI32SSC_ADC_CLK_SRC_BCR				3

//*****************************************************************************
// AI32SSC_IOCTL_ADC_ENABLE					SSCR D5
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AI32SSC_ADC_ENABLE_NO				0	// Disable ADC clocking.
#define	AI32SSC_ADC_ENABLE_YES				1	// Enable ADC clocking.

//*****************************************************************************
// AI32SSC_IOCTL_AIN_BUF_CLEAR				IBCR D18
//
//	Parameter:	None.

//*****************************************************************************
// AI32SSC_IOCTL_AIN_BUF_LEVEL				BUFSR D0-D18
//
//	Parameter:	s32*
//		The value returned is the current input buffer fill level.

//*****************************************************************************
// AI32SSC_IOCTL_AIN_BUF_OVERFLOW			BCTLR D17
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AI32SSC_AIN_BUF_OVERFLOW_CLEAR		0
#define	AI32SSC_AIN_BUF_OVERFLOW_IGNORE		1

// For queries the following values are returned.
#define	AI32SSC_AIN_BUF_OVERFLOW_NO			0
#define	AI32SSC_AIN_BUF_OVERFLOW_YES		1

//*****************************************************************************
// AI32SSC_IOCTL_AIN_BUF_THR_LVL			IBCR D0-D17
//
//	Parameter:	s32*
//		Pass in any valid value from 0x0 to 0x3FFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AI32SSC_IOCTL_AIN_BUF_THR_STS			IBCR D19
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AI32SSC_AIN_BUF_THR_STS_CLEAR		0
#define	AI32SSC_AIN_BUF_THR_STS_SET			1

//*****************************************************************************
// AI32SSC_IOCTL_AIN_BUF_UNDERFLOW			BCTLR D16
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_AIN_BUF_UNDERFLOW_CLEAR		0
#define	AI32SSC_AIN_BUF_UNDERFLOW_IGNORE	1

// For queries the following values are returned.
#define	AI32SSC_AIN_BUF_UNDERFLOW_NO		0
#define	AI32SSC_AIN_BUF_UNDERFLOW_YES		1

//*****************************************************************************
// AI32SSC_IOCTL_AIN_MODE					BCTLR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_AIN_MODE_DIFF				0	// Differential
#define	AI32SSC_AIN_MODE_ZERO				2	// Zero test
#define	AI32SSC_AIN_MODE_VREF				3	// Vref test

//*****************************************************************************
// AI32SSC_IOCTL_AIN_RANGE					BCTLR D4-D5
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_AIN_RANGE_2_5V				0	// +- 2.5 volts
#define	AI32SSC_AIN_RANGE_5V				1	// +- 5 volts
#define	AI32SSC_AIN_RANGE_10V				2	// +- 10 volts

//*****************************************************************************
// AI32SSC_IOCTL_BURST_BUSY					BCTLR D12
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AI32SSC_BURST_BUSY_IDLE				0
#define	AI32SSC_BURST_BUSY_ACTIVE			1

//*****************************************************************************
// AI32SSC_IOCTL_BURST_SIZE					BSIZR D0-D19
//
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is 0-0xFFFFF.

//*****************************************************************************
// AI32SSC_IOCTL_BURST_SYNC					SSCR D8-D9
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_BURST_SYNC_DISABLE			0
#define	AI32SSC_BURST_SYNC_RBG				1
#define	AI32SSC_BURST_SYNC_EXT				2
#define	AI32SSC_BURST_SYNC_BCR				3

//*****************************************************************************
// AI32SSC_IOCTL_CHAN_ACTIVE				SSCR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_CHAN_ACTIVE_SINGLE			0
#define	AI32SSC_CHAN_ACTIVE_0_1				1
#define	AI32SSC_CHAN_ACTIVE_0_3				2
#define	AI32SSC_CHAN_ACTIVE_0_7				3
#define	AI32SSC_CHAN_ACTIVE_0_15			4
#define	AI32SSC_CHAN_ACTIVE_0_31			5
#define	AI32SSC_CHAN_ACTIVE_RANGE			7

//*****************************************************************************
// AI32SSC_IOCTL_CHAN_FIRST					ACAR D0-D7
//
//	Parameter:	s32*
//		Pass in any valid value from zero to the index of the last channel,
//		but not more than the LAST channel selection, or
//		-1 to read the current setting.

//*****************************************************************************
// AI32SSC_IOCTL_CHAN_LAST					ACAR D8-D15
//
//	Parameter:	s32*
//		Pass in any valid value from zero to the index of the last channel,
//		but not less than the FIRST channel selection, or
//		-1 to read the current setting.

//*****************************************************************************
// AI32SSC_IOCTL_CHAN_SINGLE				SSCR D12-D17
//
//	Parameter:	s32*
//		Pass in any valid value from zero to the index of the last channel, or
//		-1 to read the current setting.

//*****************************************************************************
// AI32SSC_IOCTL_DATA_FORMAT				BCTLR D6
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_DATA_FORMAT_2S_COMP			0	// Twos Compliment
#define	AI32SSC_DATA_FORMAT_OFF_BIN			1	// Offset Binary

//*****************************************************************************
// AI32SSC_IOCTL_DATA_PACKING				BCTLR D18
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_DATA_PACKING_DISABLE		0
#define	AI32SSC_DATA_PACKING_ENABLE			1

//*****************************************************************************
// AI32SSC_IOCTL_RAG_ENABLE					RAGR D16
// AI32SSC_IOCTL_RBG_ENABLE					RBGR D16
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_GEN_ENABLE_NO				1
#define	AI32SSC_GEN_ENABLE_YES				0

//*****************************************************************************
// AI32SSC_IOCTL_RAG_NRATE					RAGR D0-D15
// AI32SSC_IOCTL_RBG_NRATE					RBGR D0-D15
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is 250-0xFFFF.

//*****************************************************************************
// AI32SSC_IOCTL_RBG_CLK_SRC				SSCR D10
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_RBG_CLK_SRC_MASTER			0
#define	AI32SSC_RBG_CLK_SRC_RAG				1

//*****************************************************************************
// AI32SSC_IOCTL_INPUT_SYNC					BCTLR D12
//
//	Parameter:	None.

//*****************************************************************************
// AI32SSC_IOCTL_IO_INV						SSCR D11
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_IO_INV_LOW					0	// assert LOW
#define	AI32SSC_IO_INV_HIGH					1	// assert HI

//*****************************************************************************
// AI32SSC_IOCTL_IRQ0_SEL					ICR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_IRQ0_INIT_DONE				0
#define	AI32SSC_IRQ0_AUTOCAL_DONE			1
#define	AI32SSC_IRQ0_SYNC_START				2
#define	AI32SSC_IRQ0_SYNC_DONE				3
#define	AI32SSC_IRQ0_BURST_START			4
#define	AI32SSC_IRQ0_BURST_DONE				5

// Retained for backwards compatibility:
#define	AI32SSC_IRQ0_AUTO_CAL_DONE			AI32SSC_IRQ0_AUTOCAL_DONE

//*****************************************************************************
// AI32SSC_IOCTL_IRQ1_SEL					ICR D4-D6
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_IRQ1_NONE					0
#define	AI32SSC_IRQ1_IN_BUF_THR_L2H			1
#define	AI32SSC_IRQ1_IN_BUF_THR_H2L			2
#define	AI32SSC_IRQ1_IN_BUF_OVR_UNDR		3

//*****************************************************************************
// AI32SSC_IOCTL_SCAN_MARKER				BCTLR D11
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_SCAN_MARKER_DISABLE			1
#define	AI32SSC_SCAN_MARKER_ENABLE			0

//*****************************************************************************
// AI32SSC_IOCTL_AUX_CLK_MODE				ASIOCR D0-D1
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_AUX_CLK_MODE_DISABLE		0
#define	AI32SSC_AUX_CLK_MODE_INPUT			1
#define	AI32SSC_AUX_CLK_MODE_OUTPUT			2

//*****************************************************************************
// AI32SSC_IOCTL_AUX_IN_POL					ASIOCR D8
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_AUX_IN_POL_LO_2_HI			0
#define	AI32SSC_AUX_IN_POL_HI_2_LO			1

//*****************************************************************************
// AI32SSC_IOCTL_AUX_NOISE					ASIOCR D10
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_AUX_NOISE_LOW				0
#define	AI32SSC_AUX_NOISE_HIGH				1

//*****************************************************************************
// AI32SSC_IOCTL_AUX_OUT_POL				ASIOCR D9
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_AUX_OUT_POL_HI_PULSE		0
#define	AI32SSC_AUX_OUT_POL_LOW_PULSE		1

//*****************************************************************************
// AI32SSC_IOCTL_AUX_SYNC_MODE				ASIOCR D2-D3
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_AUX_SYNC_MODE_DISABLE		0
#define	AI32SSC_AUX_SYNC_MODE_INPUT			1
#define	AI32SSC_AUX_SYNC_MODE_OUTPUT		2

//*****************************************************************************
// AI32SSC_IOCTL_TT_ADC_CLK_SRC				TTCR D0-D1
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_ADC_CLK_SRC_RAG			0
#define	AI32SSC_TT_ADC_CLK_SRC_EXT_SAMP		1
#define	AI32SSC_TT_ADC_CLK_SRC_EXT_REF		2

//*****************************************************************************
// AI32SSC_IOCTL_TT_ADC_ENABLE				TTCR D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_ADC_ENABLE_NO			0
#define	AI32SSC_TT_ADC_ENABLE_YES			1

//*****************************************************************************
// AI32SSC_IOCTL_TT_CHAN_MASK				TTACMR D0-D31
//
//	Parameter:	u32*
//		Pass in any bit-wise combination of bits to enable/disable the desired
//		channels. A "1" enables and "0" disables each respective channel.

//*****************************************************************************
// AI32SSC_IOCTL_TT_ENABLE					BCTLR D20
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_ENABLE_NO				0
#define	AI32SSC_TT_ENABLE_YES				1

//*****************************************************************************
// AI32SSC_IOCTL_TT_LOG_MODE				TTCR D6
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_LOG_MODE_TRIG			0
#define	AI32SSC_TT_LOG_MODE_ALL				1

//*****************************************************************************
// AI32SSC_IOCTL_TT_REF_CLK_SRC				TTCR D8
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_REF_CLK_SRC_INT			0
#define	AI32SSC_TT_REF_CLK_SRC_EXT			1

//*****************************************************************************
// AI32SSC_IOCTL_TT_REF_VAL_MODE			TTCR D5
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_REF_VAL_MODE_AUTO		0
#define	AI32SSC_TT_REF_VAL_MODE_CONST		1

//*****************************************************************************
// AI32SSC_IOCTL_TT_RESET					TTCR D9
//
//	Parameter:	None.

//*****************************************************************************
// AI32SSC_IOCTL_TT_RESET_EXT				TTCR D10
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_RESET_EXT_DISABLE		0
#define	AI32SSC_TT_RESET_EXT_ENABLE			1

//*****************************************************************************
// AI32SSC_IOCTL_TT_TAGGING					TTCR D11
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_TAGGING_DISABLE			0
#define	AI32SSC_TT_TAGGING_ENABLE			1

//*****************************************************************************
// AI32SSC_IOCTL_TT_TRIG_MODE				TTCR D4
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_TT_TRIG_MODE_CONTIN			0
#define	AI32SSC_TT_TRIG_MODE_REF_TRIG		1

//*****************************************************************************
// AI32SSC_IOCTL_TT_REF_00					TTC00TRR D0-D15
// AI32SSC_IOCTL_TT_REF_01					TTC01TRR D0-D15
// AI32SSC_IOCTL_TT_REF_02					TTC02TRR D0-D15
// AI32SSC_IOCTL_TT_REF_03					TTC03TRR D0-D15
// AI32SSC_IOCTL_TT_REF_04					TTC04TRR D0-D15
// AI32SSC_IOCTL_TT_REF_05					TTC05TRR D0-D15
// AI32SSC_IOCTL_TT_REF_06					TTC06TRR D0-D15
// AI32SSC_IOCTL_TT_REF_07					TTC07TRR D0-D15
// AI32SSC_IOCTL_TT_REF_08					TTC08TRR D0-D15
// AI32SSC_IOCTL_TT_REF_09					TTC09TRR D0-D15
// AI32SSC_IOCTL_TT_REF_10					TTC10TRR D0-D15
// AI32SSC_IOCTL_TT_REF_11					TTC11TRR D0-D15
// AI32SSC_IOCTL_TT_REF_12					TTC12TRR D0-D15
// AI32SSC_IOCTL_TT_REF_13					TTC13TRR D0-D15
// AI32SSC_IOCTL_TT_REF_14					TTC14TRR D0-D15
// AI32SSC_IOCTL_TT_REF_15					TTC15TRR D0-D15
// AI32SSC_IOCTL_TT_REF_16					TTC16TRR D0-D15
// AI32SSC_IOCTL_TT_REF_17					TTC17TRR D0-D15
// AI32SSC_IOCTL_TT_REF_18					TTC18TRR D0-D15
// AI32SSC_IOCTL_TT_REF_19					TTC19TRR D0-D15
// AI32SSC_IOCTL_TT_REF_20					TTC20TRR D0-D15
// AI32SSC_IOCTL_TT_REF_21					TTC21TRR D0-D15
// AI32SSC_IOCTL_TT_REF_22					TTC22TRR D0-D15
// AI32SSC_IOCTL_TT_REF_23					TTC23TRR D0-D15
// AI32SSC_IOCTL_TT_REF_24					TTC24TRR D0-D15
// AI32SSC_IOCTL_TT_REF_25					TTC25TRR D0-D15
// AI32SSC_IOCTL_TT_REF_26					TTC26TRR D0-D15
// AI32SSC_IOCTL_TT_REF_27					TTC27TRR D0-D15
// AI32SSC_IOCTL_TT_REF_28					TTC28TRR D0-D15
// AI32SSC_IOCTL_TT_REF_29					TTC29TRR D0-D15
// AI32SSC_IOCTL_TT_REF_30					TTC30TRR D0-D15
// AI32SSC_IOCTL_TT_REF_31					TTC31TRR D0-D15
//
//	Parameter:	s32*
//		Pass in any value from 0x0 to 0xFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AI32SSC_IOCTL_TT_THR_00					TTC00TRR D16-D31
// AI32SSC_IOCTL_TT_THR_01					TTC01TRR D16-D31
// AI32SSC_IOCTL_TT_THR_02					TTC02TRR D16-D31
// AI32SSC_IOCTL_TT_THR_03					TTC03TRR D16-D31
// AI32SSC_IOCTL_TT_THR_04					TTC04TRR D16-D31
// AI32SSC_IOCTL_TT_THR_05					TTC05TRR D16-D31
// AI32SSC_IOCTL_TT_THR_06					TTC06TRR D16-D31
// AI32SSC_IOCTL_TT_THR_07					TTC07TRR D16-D31
// AI32SSC_IOCTL_TT_THR_08					TTC08TRR D16-D31
// AI32SSC_IOCTL_TT_THR_09					TTC09TRR D16-D31
// AI32SSC_IOCTL_TT_THR_10					TTC10TRR D16-D31
// AI32SSC_IOCTL_TT_THR_11					TTC11TRR D16-D31
// AI32SSC_IOCTL_TT_THR_12					TTC12TRR D16-D31
// AI32SSC_IOCTL_TT_THR_13					TTC13TRR D16-D31
// AI32SSC_IOCTL_TT_THR_14					TTC14TRR D16-D31
// AI32SSC_IOCTL_TT_THR_15					TTC15TRR D16-D31
// AI32SSC_IOCTL_TT_THR_16					TTC16TRR D16-D31
// AI32SSC_IOCTL_TT_THR_17					TTC17TRR D16-D31
// AI32SSC_IOCTL_TT_THR_18					TTC18TRR D16-D31
// AI32SSC_IOCTL_TT_THR_19					TTC19TRR D16-D31
// AI32SSC_IOCTL_TT_THR_20					TTC20TRR D16-D31
// AI32SSC_IOCTL_TT_THR_21					TTC21TRR D16-D31
// AI32SSC_IOCTL_TT_THR_22					TTC22TRR D16-D31
// AI32SSC_IOCTL_TT_THR_23					TTC23TRR D16-D31
// AI32SSC_IOCTL_TT_THR_24					TTC24TRR D16-D31
// AI32SSC_IOCTL_TT_THR_25					TTC25TRR D16-D31
// AI32SSC_IOCTL_TT_THR_26					TTC26TRR D16-D31
// AI32SSC_IOCTL_TT_THR_27					TTC27TRR D16-D31
// AI32SSC_IOCTL_TT_THR_28					TTC28TRR D16-D31
// AI32SSC_IOCTL_TT_THR_29					TTC29TRR D16-D31
// AI32SSC_IOCTL_TT_THR_30					TTC30TRR D16-D31
// AI32SSC_IOCTL_TT_THR_31					TTC31TRR D16-D31
//
//	Parameter:	s32*
//		Pass in any value from 0x0 to 0xFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AI32SSC_IOCTL_TT_NRATE					TTRDR D0-D19
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is 2-0xFFFFF.

//*****************************************************************************
// AI32SSC_IOCTL_RX_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AI32SSC_IO_ABORT_NO					0
#define	AI32SSC_IO_ABORT_YES				1

//*****************************************************************************
// AI32SSC_IOCTL_WAIT_EVENT					all fields must be valid
// AI32SSC_IOCTL_WAIT_CANCEL				fields need not be valid
// AI32SSC_IOCTL_WAIT_STATUS				fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc
#define	AI32SSC_WAIT_GSC_INIT_DONE			0x0001
#define	AI32SSC_WAIT_GSC_AUTOCAL_DONE		0x0002
#define	AI32SSC_WAIT_GSC_SYNC_START			0x0004
#define	AI32SSC_WAIT_GSC_SYNC_DONE			0x0008
#define	AI32SSC_WAIT_GSC_BURST_START		0x0010
#define	AI32SSC_WAIT_GSC_BURST_DONE			0x0020
#define	AI32SSC_WAIT_GSC_IN_BUF_THR_L2H		0x0040
#define	AI32SSC_WAIT_GSC_IN_BUF_THR_H2L		0x0080
#define	AI32SSC_WAIT_GSC_IN_BUF_OVR_UNDR	0x0100
#define	AI32SSC_WAIT_GSC_ALL				0x01FF
// gsc_wait_t.alt flags
#define	AI32SSC_WAIT_ALT_ALL				0x0000
// gsc_wait_t.io
#define	AI32SSC_WAIT_IO_RX_ABORT			0x0001
#define	AI32SSC_WAIT_IO_RX_DONE				0x0002
#define	AI32SSC_WAIT_IO_RX_ERROR			0x0004
#define	AI32SSC_WAIT_IO_RX_TIMEOUT			0x0008

#define	AI32SSC_WAIT_IO_ALL					0x000F

// Retained for backwards compatibility:
#define	AI32SSC_WAIT_GSC_AUTO_CAL_DONE		AI32SSC_WAIT_GSC_AUTOCAL_DONE

//*****************************************************************************
// AI32SSC_IOCTL_SCAN_MARKER_VAL			SMUWR D0-D15, SMLWR D0-D15
//
//	Parameter:	u32*
//		Pass in any value between the range 0 to 0xFFFFFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AI32SSC_IOCTL_RBG_SYNC_OUTPUT			SSCR D6
// Feature:
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_RBG_SYNC_OUTPUT_DISABLE		0
#define	AI32SSC_RBG_SYNC_OUTPUT_ENABLE		1

//*****************************************************************************
// AI32SSC_IOCTL_LL_DOH						BCTLR D10
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI32SSC_LL_DOH_NO					0
#define	AI32SSC_LL_DOH_YES					1

//*****************************************************************************
// AI32SSC_IOCTL_LL_READ					LL Data Regs D0-D15
//
//	Parameter:	ai32ssc_ll_data_t*

typedef struct
{
	u32	mask;		// Read only these LL registers.
	u32	data[32];
} ai32ssc_ll_data_t;

//*****************************************************************************
// AI32SSC_IOCTL_RX_IO_PIO_THRESH			DRIVER TESTING ONLY!
//
//	Parameter:	s32*
//		Pass in any value of zero or greater, or -1.
//		Pass in -1 to read the current setting.

#define	AI32SSC_IO_PIO_THRESH_DEFAULT		21	// samples, based on testing

//*****************************************************************************
// AI32SSC_IOCTL_RX_IO_BMDMA_THRESH			DRIVER TESTING ONLY!
//
//	Parameter:	s32*
//		Pass in any value of zero or greater, or -1.
//		Pass in -1 to read the current setting.

#define	AI32SSC_IO_BMDMA_THRESH_DEFAULT		22	// samples



#endif
