// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/driver/irq.c $
// $Rev: 53701 $
// $Date: 2023-09-07 13:58:16 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Device Driver: source file

#include "main.h"



//*****************************************************************************
void dev_irq_isr_local_handler(dev_data_t* dev)
{
	#define	ICR_IRQ0_REQUEST	0x08
	#define	ICR_IRQ1_REQUEST	0x80

	u32	icr;
	u32	irq;

	icr	= os_reg_mem_rx_u32(NULL, dev->vaddr.gsc_icr_32);

	if (icr & ICR_IRQ0_REQUEST)
	{
		// Clear the interrupt.

		if (dev->cache.fw_ver >= 0x005)
			icr	= (icr & ~ICR_IRQ0_REQUEST) | ICR_IRQ1_REQUEST;
		else
			icr	= icr & ~(ICR_IRQ0_REQUEST | ICR_IRQ1_REQUEST);

		os_reg_mem_tx_u32(NULL, dev->vaddr.gsc_icr_32, icr);

		// Resume any blocked threads.
		irq	= GSC_FIELD_DECODE(icr, 2, 0);

		switch (irq)
		{
			default:

				gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
				break;

			case AI32SSC_IRQ0_INIT_DONE:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_INIT_DONE);
				break;

			case AI32SSC_IRQ0_AUTOCAL_DONE:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_AUTOCAL_DONE);
				break;

			case AI32SSC_IRQ0_SYNC_START:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_SYNC_START);
				break;

			case AI32SSC_IRQ0_SYNC_DONE:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_SYNC_DONE);
				break;

			case AI32SSC_IRQ0_BURST_START:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_BURST_START);
				break;

			case AI32SSC_IRQ0_BURST_DONE:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_BURST_DONE);
				break;
		}
	}
	else if (icr & ICR_IRQ1_REQUEST)
	{
		// Clear the interrupt.

		if (dev->cache.fw_ver >= 0x005)
			icr	= (icr & ~ICR_IRQ1_REQUEST) | ICR_IRQ0_REQUEST;
		else
			icr	= icr & ~(ICR_IRQ1_REQUEST | ICR_IRQ0_REQUEST);

		os_reg_mem_tx_u32(NULL, dev->vaddr.gsc_icr_32, icr);

		// Resume any blocked threads.
		irq	= GSC_FIELD_DECODE(icr, 6, 4);

		switch (irq)
		{
			default:

				gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
				break;

			case AI32SSC_IRQ1_IN_BUF_THR_L2H:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_IN_BUF_THR_L2H);
				break;

			case AI32SSC_IRQ1_IN_BUF_THR_H2L:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_IN_BUF_THR_H2L);
				break;

			case AI32SSC_IRQ1_IN_BUF_OVR_UNDR:

				gsc_wait_resume_irq_gsc(dev, AI32SSC_WAIT_GSC_IN_BUF_OVR_UNDR);
				break;
		}
	}
	else
	{
		// We don't know the source of the interrupt.
		gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
	}
}



//*****************************************************************************
int dev_irq_create(dev_data_t* dev)
{
	int	ret;

	os_reg_mem_tx_u32(dev, dev->vaddr.gsc_icr_32, 0);
	ret	= gsc_irq_create(dev);
	return(ret);
}



//*****************************************************************************
void dev_irq_destroy(dev_data_t* dev)
{
	if (dev->vaddr.gsc_icr_32)
		os_reg_mem_tx_u32(dev, dev->vaddr.gsc_icr_32, 0);

	gsc_irq_destroy(dev);
}


