// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/api/read.c $
// $Rev: 44794 $
// $Date: 2019-05-03 14:28:28 -0500 (Fri, 03 May 2019) $

// 16AI32SSC: API Library: source file

#include "main.h"



//*****************************************************************************
// Return Values:
//	>=0	= success, the number of bytes transferred
//	<0  = failure, value is -errno or -GetLastError (Windows only)
int ai32ssc_read(int fd, void* dst, size_t bytes)
{
	int	ret;

	if (bytes > GSC_IO_SIZE_QTY_MASK)
		bytes	= GSC_IO_SIZE_QTY_MASK & ~0x3;

	bytes	|= STREAM_ID_RX;
	ret		= gsc_api_read(fd, dst, bytes);
	return(ret);
}


