// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/utils/util_rx_io_overflow.c $
// $Rev: 42822 $
// $Date: 2018-05-17 16:26:47 -0500 (Thu, 17 May 2018) $

// 12AISS8AO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss8ao4_rx_io_overflow
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS8AO4_IOCTL_RX_IO_OVERFLOW service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss8ao4_rx_io_overflow(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Rx I/O Overflow", index);

	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_RX_IO_OVERFLOW, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AISS8AO4_IO_OVERFLOW_IGNORE:

			ptr	= "Ignore";
			break;

		case AISS8AO4_IO_OVERFLOW_CHECK:

			ptr	= "Check";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


