// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/utils/util_id.c $
// $Rev: 51886 $
// $Date: 2022-10-20 09:53:54 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	_id_device_pci
*
*	Purpose:
*
*		Identify the device using the PCI registers.
*
*	Arguments:
*
*		fd		The handle used to access the device.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

static int _id_device_pci(int fd)
{
	int	errs	= 0;
	u32	reg;

	gsc_label("Vendor ID");
	errs	+= aiss8ao4_reg_read(fd, -1, 0, GSC_PCI_9080_VIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Device ID");
	errs	+= aiss8ao4_reg_read(fd, -1, 0, GSC_PCI_9080_DIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x9080)
	{
		printf("(PCI9080)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Sub Vendor ID");
	errs	+= aiss8ao4_reg_read(fd, -1, 0, GSC_PCI_9080_SVID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Subsystem ID");
	errs	+= aiss8ao4_reg_read(fd, -1, 0, GSC_PCI_9080_SID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x2880)
	{
		printf("(12AISS8AO4)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	aiss8ao4_id_device
*
*	Purpose:
*
*		Identify the device.
*
*	Arguments:
*
*		fd		The handle to use to access the device.
*
*		index	The index of the device or -1 if we don't care.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aiss8ao4_id_device(int fd, int index, int verbose)
{
	char*	desc		= "";
	s32		device_type;
	int		errs;

	if (verbose)
		gsc_label_index("Device", index);

	errs	= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_DEVICE_TYPE, &device_type);

	if (errs == 0)
	{
		switch (device_type)
		{
			default:

				errs	= 1;

				if (verbose)
				{
					printf(	"FAIL <---  (unexpected device type: %ld)",
							(long) device_type);
				}

				break;

			case GSC_DEV_TYPE_12AISS8AO4:

				desc	= "12AISS8AO4";
				break;
		}
	}

	if (verbose)
		printf("%s\n", desc);

	gsc_label_level_inc();

	errs	+= _id_device_pci(fd);

	gsc_label_level_dec();

	return(errs);
}



