// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/utils/util_config_ai.c $
// $Rev: 51886 $
// $Date: 2022-10-20 09:53:54 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss8ao4_config_ai
*
*	Purpose:
*
*		Configure the given device's analog input options.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		fsamp	This is the desired Fsamp rate, of -1 to use the default.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aiss8ao4_config_ai(int fd, int index, int verbose, s32 fsamp)
{
	int	errs	= 0;
	s32	ndiv	= 0xFFFF;
	s32	size	= 16L * 1024;

	if (verbose)
	{
		gsc_label_index("Input Configuration", index);
		gsc_label_level_inc();
		printf("\n");
	}

	errs	+= aiss8ao4_query				(fd, index, verbose, AISS8AO4_QUERY_FIFO_SIZE_RX, &size);

	errs	+= aiss8ao4_initialize			(fd, index, verbose);
	errs	+= aiss8ao4_rx_io_mode			(fd, index, verbose, GSC_IO_MODE_PIO,				NULL);
	errs	+= aiss8ao4_rx_io_overflow		(fd, index, verbose, AISS8AO4_IO_OVERFLOW_CHECK,	NULL);
	errs	+= aiss8ao4_rx_io_timeout		(fd, index, verbose, 30,							NULL);
	errs	+= aiss8ao4_data_format			(fd, index, verbose, AISS8AO4_DATA_FORMAT_OFF_BIN,	NULL);
	errs	+= aiss8ao4_oper_mode			(fd, index, verbose, AISS8AO4_OPER_MODE_INIT,		NULL);

	errs	+= aiss8ao4_ai_mode				(fd, index, verbose, AISS8AO4_AI_MODE_DIFF,			NULL);
	errs	+= aiss8ao4_ai_buf_thr_lvl		(fd, index, verbose, size / 2,						NULL);
	errs	+= aiss8ao4_ai_burst_enable		(fd, index, verbose, AISS8AO4_BURST_ENABLE_NO,		NULL);
	errs	+= aiss8ao4_ai_chan_sel			(fd, index, verbose, 0xFF,							NULL);
	errs	+= aiss8ao4_ai_range_a			(fd, index, verbose, AISS8AO4_AI_RANGE_10V,			NULL);
	errs	+= aiss8ao4_ai_range_b			(fd, index, verbose, AISS8AO4_AI_RANGE_10V,			NULL);
	errs	+= aiss8ao4_fsamp_ai_compute	(fd, index, verbose, fsamp, &ndiv,					NULL);
	errs	+= aiss8ao4_gen_a_ndiv			(fd, index, verbose, ndiv,							NULL);
	errs	+= aiss8ao4_gen_a_enable		(fd, index, verbose, AISS8AO4_GEN_ENABLE_YES,		NULL);
	errs	+= aiss8ao4_gen_b_enable		(fd, index, verbose, AISS8AO4_GEN_ENABLE_NO,		NULL);
	errs	+= aiss8ao4_fsamp_ai_report_all	(fd, index, verbose,								NULL);

	errs	+= aiss8ao4_auto_calibrate		(fd, index, verbose);
	errs	+= aiss8ao4_ai_enable			(fd, index, verbose, AISS8AO4_AIO_ENABLE_YES,		NULL);
	errs	+= aiss8ao4_ai_buf_clear		(fd, index, verbose);
	errs	+= aiss8ao4_ai_buf_overflow		(fd, index, verbose, AISS8AO4_BUF_OVERFLOW_CLEAR,	NULL);
	errs	+= aiss8ao4_ai_buf_level		(fd, index, verbose,								NULL);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


