// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/utils/util_ai_chan_sel.c $
// $Rev: 42822 $
// $Date: 2018-05-17 16:26:47 -0500 (Thu, 17 May 2018) $

// 12AISS8AO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss8ao4_ai_chan_sel
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS8AO4_IOCTL_AI_CHAN_SEL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss8ao4_ai_chan_sel(int fd, int index, int verbose, s32 set, s32* get)
{
	int	errs;
	int	ret;
	s32	qty		= 0;

	if (verbose)
		gsc_label_index("AI Channel Select", index);

	errs	= aiss8ao4_query(fd, -1, 0, AISS8AO4_QUERY_CHANNEL_AI_QTY, &qty);

	if (qty == 8)
		set	&= 0xFF;
	else if (qty == 4)
		set	&= 0xF;
	else
		set	= 0;

	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_CHAN_SEL, &set);
	errs	+= ret ? 1 : 0;

	if (verbose)
		printf("%s  (0x%lX)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


