// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/utils/util_ai_burst_status.c $
// $Rev: 42822 $
// $Date: 2018-05-17 16:26:47 -0500 (Thu, 17 May 2018) $

// 12AISS8AO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss8ao4_ai_burst_status
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS8AO4_IOCTL_AI_BURST_STATUS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss8ao4_ai_burst_status(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;
	s32			set;

	if (verbose)
		gsc_label_index("AI Burst Status", index);

	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BURST_STATUS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AISS8AO4_BURST_STATUS_NOT_READY:

			ptr	= "Not Ready";
			break;

		case AISS8AO4_BURST_STATUS_READY:

			ptr	= "Ready";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


