// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/utils/util_ai_buf_thr_lvl.c $
// $Rev: 43135 $
// $Date: 2018-06-29 14:14:09 -0500 (Fri, 29 Jun 2018) $

// 12AISS8AO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss8ao4_ai_buf_thr_lvl
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS8AO4_IOCTL_AI_BUF_THR_LVL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss8ao4_ai_buf_thr_lvl(int fd, int index, int verbose, s32 set, s32* get)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("AI Buffer Thresh Level", index);

	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BUF_THR_LVL, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		printf("%s  (", errs ? "FAIL <---" : "PASS");
		gsc_label_long_comma((long) set);
		printf(", 0x%lX)\n", (long) set);
	}

	if (get)
		get[0]	= set;

	return(errs);
}


