// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/utils/util_ai_buf_clear.c $
// $Rev: 42822 $
// $Date: 2018-05-17 16:26:47 -0500 (Thu, 17 May 2018) $

// 12AISS8AO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss8ao4_ai_buf_clear
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS8AO4_IOCTL_AI_BUF_CLEAR service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss8ao4_ai_buf_clear(int fd, int index, int verbose)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("AI Buffer Clear", index);

	ret		= aiss8ao4_ioctl(fd, AISS8AO4_IOCTL_AI_BUF_CLEAR, NULL);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


