// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/utils/ioctl.c $
// $Rev: 51886 $
// $Date: 2022-10-20 09:53:54 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss8ao4_ioctl_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device IOCTL call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		request	The IOCTL service to request.
*
*		arg		The argument for the IOCTL service.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int aiss8ao4_ioctl_util(int fd, int index, int verbose, int request, void *arg)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("IOCTL", index);

	ret		= aiss8ao4_ioctl(fd, request, arg);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		printf(	"%s  (#%d)\n",
				errs ? "FAIL <---" : "PASS",
				(int) OS_IOCTL_INDEX_DECODE(request));
	}

	return(errs);
}


