// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/stream/perform.c $
// $Rev: 51902 $
// $Date: 2022-10-20 10:18:56 -0500 (Thu, 20 Oct 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _buffer_config(void)
{
	int		errs;

	gsc_label("Buffer Configuration");
	errs	= gsc_buf_man_init();

	if (errs == 0)
		errs	= gsc_buf_man_setup(BUFFER_QTY, BUFFER_SIZE);

	if (errs)
	{
	}
	else
	{
		printf("PASS  (%d buffers, ", (int) BUFFER_QTY);
		gsc_label_long_comma(BUFFER_SIZE);
		printf(" bytes each)\n");
	}

	return(errs);
}



//*****************************************************************************
static void _buffer_free(void)
{
	gsc_label("Buffer Free");
	gsc_buf_man_free_all();
	printf("Done\n");
}



//*****************************************************************************
static void _buffer_stats(void)
{
	gsc_buf_man_stats();
}



//*****************************************************************************
static void _buffer_stop(void)
{
	gsc_buf_man_stop();
}



//*****************************************************************************
static int _config_device(const args_t* args)
{
	s32	chan_qty;
	int	errs		= 0;
	s32	rate;
	s32	secs;

	gsc_label("Device Configuration");
	errs	+= aiss8ao4_config_ai	(args->fd, -1, 0, args->fsamp);
	printf("%s\n", errs ? "FAIL <---" : "PASS");

	errs	+= aiss8ao4_rx_io_mode	(args->fd, -1, 1, args->io_mode, NULL);

	// Compute a timeout period based on the sample rate.
	errs	+= aiss8ao4_query				(args->fd, -1, 1, AISS8AO4_QUERY_CHANNEL_AI_QTY, &chan_qty);
	errs	+= aiss8ao4_fsamp_ai_report_all	(args->fd, -1, 1, &rate);
	secs	= BUFFER_SIZE / rate / chan_qty + 5;
	errs	+= aiss8ao4_rx_io_timeout		(args->fd, -1, 1, secs, NULL);

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static int _work_start(rx_data_t* rx, tx_data_t* tx, int errs)
{
	gsc_label("Start Working");

	if (errs)
	{
		printf("ABORTED DUE TO SETUP ERRORS <---\n");
		errs	= 0;
	}
	else
	{
		printf("\n");
		gsc_label_level_inc();

		// Begin working.

		if (errs == 0)
		{
			tx->start	= 1;
			rx->start	= 1;
		}

		gsc_label("Working");

		if (errs)
		{
			tx->stop	= 1;
			rx->stop	= 1;
			printf("ABORTED DUE TO SETUP ERRORS <---\n");
		}
		else
		{
			printf("Done\n");
			gsc_label("Waiting");

			for (;;)
			{
				if ((rx->errs) || (tx->errs))
				{
					tx->stop	= 1;
					rx->stop	= 1;
					_buffer_stop();
				}

				if ((rx->done) && (tx->done))
					break;

				gsc_time_sleep_ms(50);
			}

			_buffer_stop();
			printf("Done\n");
		}

		gsc_label_level_dec();
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args, rx_data_t* rx, tx_data_t* tx)
{
	int	errs	= 0;

	rx->args	= args;
	rx->fd		= args->fd;

	tx->args	= args;
	tx->fd		= args->fd;

	errs	+= _config_device(args);
	errs	+= _buffer_config();

	errs	+= rx_start(rx);
	errs	+= tx_start(tx);

	errs	+= _work_start(rx, tx, errs);

	errs	+= rx_stop(rx);
	errs	+= tx_stop(tx);

	if (args->stats)
		_buffer_stats();

	_buffer_free();

	if (tx->validate)
		tx_validation_results();

	errs	+= aiss8ao4_ai_buf_overflow(args->fd, -1, 1, -1, NULL);

	return(errs);
}


