// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/12AISS8AO4/samples/signals/perform.c $
// $Rev: 50268 $
// $Date: 2022-02-10 19:18:21 -0600 (Thu, 10 Feb 2022) $

// 12AISS8AO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;

	errs	+= aiss8ao4_initialize		(args->fd, -1, 1);
	errs	+= aiss8ao4_oper_mode		(args->fd, -1, 1, AISS8AO4_OPER_MODE_INIT, NULL);
	errs	+= aiss8ao4_ai_chan_sel		(args->fd, -1, 1, 1, NULL);
	errs	+= aiss8ao4_ai_enable		(args->fd, -1, 1, AISS8AO4_AIO_ENABLE_YES, NULL);
	errs	+= aiss8ao4_ao_clock_mode	(args->fd, -1, 1, AISS8AO4_AO_CLOCK_MODE_ASYNC, NULL);

	// The input clock signal.

	gsc_label("Input Clock");
	printf("\n");
	gsc_label_level_inc();
	errs	+= aiss8ao4_gen_a_ndiv		(args->fd, -1, 1, 320, NULL);
	errs	+= aiss8ao4_gen_a_enable	(args->fd, -1, 1, AISS8AO4_GEN_ENABLE_YES, NULL);
	errs	+= aiss8ao4_ai_enable		(args->fd, -1, 1, AISS8AO4_AIO_ENABLE_YES, NULL);
	gsc_label_level_dec();

	// The input trigger signal.

	gsc_label("Input Trigger");
	printf("\n");
	gsc_label_level_inc();
	errs	+= aiss8ao4_ai_burst_size	(args->fd, -1, 1, 2, NULL);
	errs	+= aiss8ao4_ai_burst_enable	(args->fd, -1, 1, AISS8AO4_BURST_ENABLE_YES, NULL);
	errs	+= aiss8ao4_gen_b_ndiv		(args->fd, -1, 1, 960, NULL);
	errs	+= aiss8ao4_gen_b_enable	(args->fd, -1, 1, AISS8AO4_GEN_ENABLE_YES, NULL);
	gsc_label_level_dec();

	// The output clock signal.

	gsc_label("Output Clock");
	printf("\n");
	gsc_label_level_inc();
	errs	+= aiss8ao4_ao_clock_mode	(args->fd, -1, 1, AISS8AO4_AO_CLOCK_MODE_SYNC, NULL);
	gsc_label_level_dec();

	// Wait a bit.

	gsc_label("Waiting");
	os_sleep_ms(args->seconds * 1000);
	printf("Done\n");

	errs	+= aiss8ao4_initialize		(args->fd, -1, 1);

	return(errs);
}



